(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11295,        382]
NotebookOptionsPosition[      8652,        294]
NotebookOutlinePosition[      9950,        331]
CellTagsIndexPosition[      9866,        326]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxOutliers" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxOutliers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxOutliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxOutlierMarkers", "ObjectName",
 CellID->4472],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxOutlierMarkers"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies markers to be used for outliers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are the same as for ",
 Cell[BoxData[
  ButtonBox["PlotMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18434],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"BoxOutlierMarkers", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the outliers are drawn as points. "
}], "Notes",
 CellID->20718],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"BoxOutlierMarkers", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", the outliers are not drawn. "
}], "Notes",
 CellID->5841],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"BoxOutlierShapes", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["g", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["g", "TI"], "2"]}], "}"}]}]], "InlineFormula"],
 " can be used to specify ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " as markers for near outliers, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " as markers for far outliers."
}], "Notes",
 CellID->14867]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487459834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->63855678],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->210023134],

Cell["\<\
Use triangles for near outliers and squares for far outliers:\
\>", "ExampleText",
 CellID->524907126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331921556],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FrE0EUnmSSNtGCAYWmiUhI27THFkRK8SAImkPVpIgnKYQgtGhQag9F
9Df0bNVaMDZFyUVPOXnsRSg99dif0GOP63tvZ7u7s0l2N9niNpkhOzsv33vf
vL593Xk7Sx5VNlZf1Coba9VK7uF65c3qWvVt7sHrdfiKRxiLrMKxkmYw1hjT
D2xrcOjDIEfjGp3YMsOGEuPGjBr7SPL+/j7T21XseKlUEvg36CJtLbdJnpqa
EpZJsoxGo6enpwjVXSyPjo5slrVaTeCmZQpGUTjHJYZPJC8sLAiGUWJIJpMC
/37OcA3FmGnJWKwtFzgNrptcW1tbPXB9JhmiJ/yKE9fExITA91y4UH/b8Af+
HJMDrpBHDqs/X0je3NwU/nDq5ufnBd7wwbVDciqVElwULLyKDq5OV40Y4mau
MYaR+tExT76STxA9nI3yykVX5BRkEvvZUXOX5Gq1KuTOnNg9DgVqgOHwZthQ
FX0V/WFFVfT7QeMiglzTV0TjLK+MdquEBUU52kXGoSz3zxYX4tIF+TQi4kBa
I6aWQeefjcXP0UA8HLV46P3KhTML1R1iUND3JJ+dnf2hxgrY8WazKeRpkg8O
DoT+B8eV0hmOj4/vUWPT2PHFxcVEIoHDAslQl8MkTgarL3WST05OcrkcDveU
5iXWLJN8eHgoMqlEmdRoNNLpNA6XSYa8sejbM6tsMM7M3IEPK2HHC4Xbmcwk
Dssk5/Nz2ewtVF128QWT9d1f+LA6dvzVy1+ZjLJUlqGytGV+aL1UlmGz1LfX
jCZXmZ2qTe/8VN3a9vO61cOyjENZ/v9z38zeX3n+Gz6sjh1/9nRvdmbpIubG
h4kn9P2N63PynJP5u4Mfa085zM0cljO3/wy+XP/PytL3ainXiePjOVudmM8X
vMztVrNC9WvRD2PtrTT71zSfbSEf5GfbsbEx89m2WCy6PtsiMkvZ02q1bM/W
wG7RCdfuwGCgBhgOb4YNVdHvjuoFjdEMVX/7+3LFxS2yjLfT775zHX5259sF
qYrVgnw7QKjj7QAPhNtaAcc09cYgCFTdgVT0hxVV0VfRDy+KC7TXnUq7pf6K
3lhjNcdKy1xkzXUlDn4fzM7vp87pxO6se4Jg7RZ1azwuIiq97ADaGcKZ6eo+
M7ioir6K/rCiKvoyugvdFRDN37nEqNM0c5fHbUVzchj2em/9JQWCftdcJ3/Q
ezzOGXgXC68zYL2z487Met/paRd5K0v7vZ/+o9PLvo+TxT0X/WtgZ8929LMM
R4SG+IWXX42xyD+KiolV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 350},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->280222543]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28614],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BoxOutliers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18598]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10938],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->1881]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxOutlierMarkers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 19.7557556}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxOutlierMarkers is an option for BoxWhiskerPlot which specifies \
markers to be used for outliers.", "synonyms" -> {}, "title" -> 
    "BoxOutlierMarkers", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/BoxOutlierMarkers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4351, 160, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->487459834]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9723, 319}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1236, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1859, 60, 54, 1, 70, "ObjectName",
 CellID->4472],
Cell[1916, 63, 551, 16, 70, "Usage",
 CellID->7128]
}, Open  ]],
Cell[CellGroupData[{
Cell[2504, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2982, 101, 215, 8, 70, "Notes",
 CellID->18434],
Cell[3200, 111, 270, 9, 70, "Notes",
 CellID->20718],
Cell[3473, 122, 253, 9, 70, "Notes",
 CellID->5841],
Cell[3729, 133, 585, 22, 70, "Notes",
 CellID->14867]
}, Closed]],
Cell[CellGroupData[{
Cell[4351, 160, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->487459834],
Cell[CellGroupData[{
Cell[4736, 174, 147, 5, 70, "ExampleSection",
 CellID->63855678],
Cell[4886, 181, 141, 4, 70, "Input",
 CellID->210023134],
Cell[5030, 187, 112, 3, 70, "ExampleText",
 CellID->524907126],
Cell[CellGroupData[{
Cell[5167, 194, 807, 20, 50, "Input",
 CellID->331921556],
Cell[5977, 216, 1514, 29, 371, "Output",
 Evaluatable->False,
 CellID->280222543]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7552, 252, 311, 9, 70, "SeeAlsoSection",
 CellID->28614],
Cell[7866, 263, 219, 6, 70, "SeeAlso",
 CellID->18598]
}, Open  ]],
Cell[CellGroupData[{
Cell[8122, 274, 314, 9, 70, "TutorialsSection",
 CellID->10938],
Cell[8439, 285, 171, 4, 70, "Tutorials",
 CellID->1881]
}, Open  ]],
Cell[8625, 292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

