(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11442,        385]
NotebookOptionsPosition[      8635,        291]
NotebookOutlinePosition[      9912,        327]
CellTagsIndexPosition[      9828,        322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxOutliers" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxOutliers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxOutliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxQuantile", "ObjectName",
 CellID->22501],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BoxQuantile"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["BoxWhiskerPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"]], 
      "InlineFormula"],
     " which specifies how far the box extends from the median."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8850]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["BoxQuantile"], "InlineFormula"],
 " are numbers between zero and ",
 Cell[BoxData["0.5"], "InlineFormula"],
 ", with a default of ",
 Cell[BoxData["0.25"], "InlineFormula"],
 "."
}], "Notes",
 CellID->25128],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"BoxQuantile", "->", 
   StyleBox["q", "TI"]}]], "InlineFormula"],
 ", the box is drawn from the ",
 Cell[BoxData[
  RowBox[{"0.5", "-", 
   StyleBox["q", "TI"]}]], "InlineFormula"],
 " quantile to the ",
 Cell[BoxData[
  RowBox[{"0.5", "+", 
   StyleBox["q", "TI"]}]], "InlineFormula"],
 " quantile."
}], "Notes",
 CellID->184902]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->477886349],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->120132795],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->191634878],

Cell["The default covers the middle 50% of the data:", "ExampleText",
 CellID->204799523],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "1000"}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->597942307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153527058],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FPGkEUfsugtCRGbhJM6oaDWpN6MXogKemp5UKCYpqg8UBMG0xrMOqp
aYKXnjl74ia0x/ID+ANN+An8FPveLMRlWnRnEZhd3mTn7czu997OfjvDm7fL
5MvXlU/n5euz07L94bJ8UTk7vbLfVy/xkLAArArmUhKwfA/g5OV7TFg4AkpU
A0HHZZK7j5gto87eoHjd6XRAtNvtjkywLuvdbteFedAm5Zq00uv13skE6yRE
JpOJx+NU3JD1QqHwXwvu67cGlmzbpuIvRmojCWhy+8KHnDfGF/v3vOhZ46WC
FJ41HaiTIpijvi3FsBTpt3oB93cjkS8Um+o1J3Gf+pwGpbfwWGIe5wHJjDPj
piDJi0Rxv+BZI+ZCgpam6qFVn0fe83F/699rjudvIfqA1OVqMJMIQm/gUWU2
khlnxsOOnDfGY/179u5V/EedXjyw/zZMKlb2rxlu/8tjapbIoqzX6/WaTHBA
QlSr1UQiQcVDWW80Gi788BMpDixm337GDYokxN5uqV8/cOp7R6nUK4IePtEW
rH//9gc3aJEQX7/8Zs0paw49V2NbyZrcA8KvSfMG8v7qzMq7BfmuYyj2V+ce
49qiOdO+Qe2ZuK21tR3coEVCrK6+WVpa1nxqJ8e3uEGLhNgv/FhZSc2+r/Gv
DWtyD2BN7gHT0Nza2gYn/SQhcrm867yJ0SLH5+obHQJO4/8Sz6tp3vepUfMl
U589j6GwIJlx5jGYSGZ8FJIieQrk/X2dAS1Nff8aVzQinq/lX/Ppdxvz6pt5
FDHjYUcy48y4af//mIUXdHuyScXA4/loPQ6D0jt47JiNZMaZ8WAiCXiD+025
arfZbCaTSSpuPLqK122/NrA/tJo3m82m02m91bwkzFvj/O9Ziv5KmC2naP0F
NTxW7A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3991733]
}, Open  ]],

Cell["Cover the middle 90%:", "ExampleText",
 CellID->241892751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"BoxQuantile", "\[Rule]", ".45"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->408227493],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFq20AQXXmdOBaEHG0caIQOcnsoFFzaYIjpqT0VHNttiUsLJhQc2tLi
hh5KIbmk1577A7Xpsf4A/0BBn+BPSWfWMlEUy9bKFtm1Ztld7drvjaTRSDO7
Xut557T77mPn9OS4Yz3rdT53T46/WE8/9eAjbjBmdKEcFRm0LxmblJ1LSNBo
M0zYYxw/F0lsXkIxlPr2HKp7o9GI8eFwOBKJOaLvuq4Pc8VG8pmQMh6Pn4jE
HKx4tVo1TRObZdGv1+szJfj3P5hKsiwLm38IKY1EoMrHt37ItGl80zvnzciM
fADJIzMn0EnKQMnGlpSDVsY76g3Y/g5FbgVkBveZxHnK61QXa6F7ifSYBiRp
nDSuChK9SBa2G5EZOR+SSTGDHjro89B7zve38b3mcv6WZa+QsrqaRhI6WAPd
VWojddJ4U/Rd1/VmBxpidqDf7xeLRWy2RB8k+fDzJEG/XH4EmTWw4o7zsFCw
sNkUfdt+YNsOQluLJX3/9g8yG2DFP7z/WyrdUYOJQPWPkphkAbowc55Og147
uoRFo/zokqJEQKs7RoylDm/hLFcnKSx+Utvi9GPSMyftTLKA9WDSdUw7kyxA
FSbGQRi9xI88xVzbtbmn5WKpm7LkYsTkjydxWXt7FchsgBXf3b2/vb0jedXe
vP4FmQ2w4of1i0KhdPu2Rk8bYpIFEJMsgJhkAboztzydxo+IFv3eqYokufhT
xbNaPsrXyzbpGUNMsgBirug6eqPpphhNv3rx0+s3vNH1j4j7brff7u8fQGYN
rHil8jifN7HZEv1e76sPP1uSLisraN2JOkicecKJp+grv/2/jjIpZlj8FL5e
zgwwMpH3FZ+5eC5uvm5mxVKqXn26i9RGksZJ4+uOTJvGw9ZzJeHL4jP9niyp
Ne3L+Wg5HepiHXTvqI0kjZPG9UQi8By2dwP/YyjPfeuBX/7ZVP61tx/UajXb
tuXefoCVeu+EuPktjv6OoBiTpvEfhgiyHQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->66664707]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1454],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BoxOutliers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2111],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->23650]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxQuantile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 20.1776414}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxQuantile is an option for BoxWhiskerPlot which specifies how far the \
box extends from the median.", "synonyms" -> {}, "title" -> "BoxQuantile", 
    "type" -> "Symbol", "uri" -> "StatisticalPlots/ref/BoxQuantile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3663, 132, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->477886349]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9685, 315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1236, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1859, 60, 49, 1, 70, "ObjectName",
 CellID->22501],
Cell[1911, 63, 553, 16, 70, "Usage",
 CellID->8850]
}, Open  ]],
Cell[CellGroupData[{
Cell[2501, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2979, 101, 262, 9, 70, "Notes",
 CellID->25128],
Cell[3244, 112, 382, 15, 70, "Notes",
 CellID->184902]
}, Closed]],
Cell[CellGroupData[{
Cell[3663, 132, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->477886349],
Cell[CellGroupData[{
Cell[4048, 146, 148, 5, 70, "ExampleSection",
 CellID->120132795],
Cell[4199, 153, 141, 4, 70, "Input",
 CellID->191634878],
Cell[4343, 159, 89, 1, 70, "ExampleText",
 CellID->204799523],
Cell[4435, 162, 256, 9, 70, "Input",
 CellID->597942307],
Cell[CellGroupData[{
Cell[4716, 175, 113, 3, 28, "Input",
 CellID->153527058],
Cell[4832, 180, 1134, 23, 366, "Output",
 Evaluatable->False,
 CellID->3991733]
}, Open  ]],
Cell[5981, 206, 64, 1, 70, "ExampleText",
 CellID->241892751],
Cell[CellGroupData[{
Cell[6070, 211, 178, 5, 28, "Input",
 CellID->408227493],
Cell[6251, 218, 1224, 24, 366, "Output",
 Evaluatable->False,
 CellID->66664707]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7536, 249, 310, 9, 70, "SeeAlsoSection",
 CellID->1454],
Cell[7849, 260, 219, 6, 70, "SeeAlso",
 CellID->15869]
}, Open  ]],
Cell[CellGroupData[{
Cell[8105, 271, 313, 9, 70, "TutorialsSection",
 CellID->2111],
Cell[8421, 282, 172, 4, 70, "Tutorials",
 CellID->23650]
}, Open  ]],
Cell[8608, 289, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

