(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50468,       1565]
NotebookOptionsPosition[     42380,       1280]
NotebookOutlinePosition[     43858,       1319]
CellTagsIndexPosition[     43772,       1314]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StemLeafPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/StemLeafPlot"], "ParetoPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/ParetoPlot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StemLeafPlot\"\>", 
       2->"\<\"ParetoPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BoxWhiskerPlot", "ObjectName",
 CellID->24408],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoxWhiskerPlot", "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates a box\[Hyphen]and\[Hyphen]whisker plot of the \
given vector of ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoxWhiskerPlot", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates multiple box\[Hyphen]and\[Hyphen]whisker \
plots. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BoxWhiskerPlot", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]also creates multiple box\[Hyphen]and\[Hyphen]whisker \
plots, with each column of the ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     " used for a separate box."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BoxWhiskerPlot"], "InlineFormula"],
 " creates a plot with a box that spans the distance between two quantiles \
surrounding the median with lines (\"whiskers\") that extend to span either \
the full data set or the data set excluding outliers."
}], "Notes",
 CellID->1908],

Cell["\<\
The default box spans from the .25 quantile to the .75 quantile.\
\>", "Notes",
 CellID->170298398],

Cell[TextData[{
 "Quantiles used are equivalent to those computed using ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17223],

Cell[TextData[{
 "Near outliers are defined as points beyond ",
 Cell[BoxData[
  FractionBox["3", "2"]], "InlineFormula"],
 " times the interquantile range from the edge of the box. Far outliers are \
defined as points beyond three times that range."
}], "Notes",
 CellID->11759],

Cell[TextData[{
 Cell[BoxData["BoxWhiskerPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->26434],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxExtraSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxExtraSpacing"], "0", Cell[
    "extra space to place between boxes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels for the boxes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxLineStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "styles to use for lines in the graph", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxMedianStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxMedianStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "additional styles for the median line", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxOrientation",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"], "Vertical", 
    Cell["orientation of the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxOutliers",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "which outliers to indicate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxOutlierMarkers",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "markers for outlier points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxQuantile",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxQuantile"], "0.25", Cell[
    "distance of quantile from median for box edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxFillingStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/BoxFillingStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "colors to use for the boxes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to put a frame around the plot", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->5204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["BoxLineStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxLineStyle"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BoxMedianStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxMedianStyle"]], 
  "InlineFormula"],
 " can be any valid graphics directives for lines."
}], "Notes",
 CellID->9091],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["BoxOrientation",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOrientation"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData["Vertical"], "InlineFormula"],
 " and ",
 Cell[BoxData["Horizontal"], "InlineFormula"],
 "."
}], "Notes",
 CellID->5945],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["BoxOutliers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutliers"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26806],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["BoxOutlierMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxOutlierMarkers"]], 
  "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["PlotMarkers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotMarkers"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18434],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["BoxQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/BoxQuantile"]], "InlineFormula"],
 " are numbers between zero and ",
 Cell[BoxData["0.5"], "InlineFormula"],
 "."
}], "Notes",
 CellID->28532]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239878629],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->55794319],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->270068752],

Cell["A box and whisker plot for a standard normal sample:", "ExampleText",
 CellID->57666891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", "1"}], "]"}], ",", "100"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131691384],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW09vEkEUn2X6R+EgaVNDejAbDq1e21gbkhJPemg0FIixaNOQRgPRBoON
h8aEnrxy8eIXEOKFRD4AX8CEj8BHqfMerC5jF4bdWpb2N5l5+97u7/d2ln0s
b5idZ8WT0pvj4kn5qGg/rRY/lMpHH+0nlaraJS0hrJJqhwmh9HMh+u3OuSpK
KQgqZAlJ+7nw5oVqVqiOninxoNPpCNlutztcxBrb3W7XhemzF5Q2p7bzmpca
271e7zEXsUZCplKpaDRK6jrbmUzmH4+LLk/iAs9Nx7Nt26T++MMUckBRJeKY
LuacsafbGpI8zSvz+0QMs3MtcNf+Iie5YvqsIo4PI4Z+t4G8SiQBw9w/IMOP
RAwBicgAEpFxk5CLg7tonhve0pDm2e/l5dEX9WF0Hu2/1/6ZyKJnC4mnGZCI
jKtC5tje3X2+vb2jqsiSkJubj2KxGKl5tqvVTy78KE/KPnj1TVWRIyELL78O
7Czbe5kvq6v3CJof7+nz6S9VRZOEfP/u5zVgEjD8vQQTTEQ6mLPFpDECZfr6
KMrcA89ODP1br48zgvqi8dFeiPozfV/B79psRaknM73zVlXRJCG3Hu4vLa34
ZC4v3w3xdeJ3B0wwEelggonvCJhTzLVynDFtbOQGdrafQW0VDD3V6/UaF5El
ISuVSjweJzXPdqvVcuHx7yiQ4+a4CBjsTTb/zP/1Dtw0mF6jyrDe+5uOxNML
SEQGkIgMIBFDQJojaS6CpiL8vUsmJmJOnjVHNUbE+Fz+meNnZ5A3Xxcknl9A
IjKARGQAiRgKijxT4j6vhm40GolEgtR1z9XROrvmnGdoVXQ6nU4mk6NXReue
SFzO+m+vlSXDqHG5ZhC0O6OkXHRfNYtVPZsmccBH9DOQeM1HnOuhPYe8h7Sy
pyas3xUfEVs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 351},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->585639235]
}, Open  ]],

Cell["\<\
A box and whisker plot for a normal sample and a uniform sample:\
\>", "ExampleText",
 CellID->105930128],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "100"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "100"}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[3]:=",
 CellID->3484384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data1", ",", "data2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->374492077],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWzFv00AUvuTSNrRqmipSZTWIZiIJiFYqUocqjWApC0iUhFaAGKJQlAhQ
orYTAnVCGbOwMHlM6RKJP8AfQMrSPWMklvyEcO9s17Fl1/YlbRz8TvHzPb/v
fXe+O12e7+xnpZPK4afSSbVcSj05KtUr1fJxard2xC7RECGhCjs2JMLyA0KU
A1KVHUrWPldmkjKHM3aOsPM+v/oOJNV4Btyq6cQW9dOkv7REnZv04gioFoiI
rms1g7sKM+1cPR+4aAk9t6RyvWJH6PLKcLkFhzsHewgaamKeYBAvC8S+rTXP
dVmWiZLSIEBX7X9d38MAkdeItBoDfqpfUJGzA2WunXHtMTdkIZ48CVVdWApr
6hAywsQMU/dsGW6ZLGYG+7LFPWd51XSL17YKaxxTMBqmCYkzSrCQ2N/BQmJ/
BwuJ/e1P5JzaN+6jnqjJEnHtOXqEKF72JDwxPsT5BJHY34i0Qma4LsvyKU8k
AwLsBl1f67sYmMdDRmPM77xnP5IBQTc3CwZdL/HCoS5M//L5D/uRAgj0RM9r
8zSMX9/WEj395gnRKMSU5njdPQNf4TWseJoj2lG5IIa/68DB979oo9F4xBNZ
BkFzuVwqlYJsguudTkfF58dYf6XsXq/3myeyDIK2Wi1JkiCbYOLxGMv7yu3d
bpfdG2SLN8ItOlLsGa1G7QFTTz15jK9sZBqdSYnXms2mGnWledRVq9Xi8Thk
s1xvt9tDfN7+xV5odV1YiEFAluVR2fr6UzVKS3N9a+v16uodgGaF7+WypJWV
27r944dfyIzMyOxDZk/zx3/bCkLMiYT09s0PUgBB955/k6TkmJij0fm1tYek
AIImkw9isbjvWwOZA8GM8wUyB5O53+8vLi6BfxEE3d7eGfKf9FOEAJNhjfb+
vV2bNdurmfX5gD2hXLmOrD/BuK+reS37DD0D4hlVx5bTXq89g9c3Er0xWe2S
f+d6vV4nSlLelbZaQZvEe5binnbrWNOyz+VnJBj8XD9EjheJ/R0sJPZ3sJDY
3/5Ewj4fbPOJvXVIPHm6jRd1j3mTJey6LHFP551PjAj9P4OIf58Jwv67z5u0
Gr+/JaF/sg+7DQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->914477369]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14776],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxExtraSpacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9220],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->415961335],

Cell["A default box and whisker plot for 2 data sets:", "ExampleText",
 CellID->53154001],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "100"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", "100"}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[2]:=",
 CellID->73404589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data1", ",", "data2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->227635225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW89vEkEUHhhaqqFUurEh1RjSpPw4GE2NTdO0G73oyYMFaRrjgWANRBtN
7cnY9MjBQy9ePHGk9ug/4D9gwsWEI0cSLz32iO8Nuyw7WdjZZbW7MJvdxzze
e9+8/Rh4MwM8Kx1V9g9KR9VyKfX0sPShUi1/TD15fwhP0RAhoQpc95IE2l1C
ehceVbh6zeGtMkgKAWfwGIHHInv2NUqq43SZVdfJUK/vnP7C0uuc0wtjeDVQ
RAxdzwzvKgzaufa4K8CE0ZrVOJnVMPfgCrHmNa5/yul5G0bQHiLsoBqVcGCG
EQvkGVCfCyNGtXuddZ3THGfhcxJHsuMJRbHvPcj3oJfK9Hq9rvGUYbyBrtn/
9BEWbDLt+sgTDX7OLyiekkfJYzA9p41x/FzHIj0jHBEdsBBHkXxd5SsP1jSr
umogOK3xXkSyymeaxzjjSqTuu3nlrt5z2t4rksdJ8ZSMSx7deEa1exavAE7X
bUakSLV0n8PoOus+a/eRslYG404kj8HwzDK9Xq+fsINkUaDdpBs7Nr9tkEBX
t9/ASbIo6Npa3qQb/mYkNPQRPn/6BSfJoxgaYdm3jLziSPk6ehuJlRLrHT+X
EEdgK3HTypSvtn7CwhlH2gaD7fHTWq32iB0kgYJubW2lUilsKkxvNpuav+ph
/r2+O53OT3aQBAraaDSSySQ2FRCPPezvmNnb7TbcGzYLY4+M4YhWo3QX1BNH
Ed717Qckkc+zXrVttVramMhwYyLHdBgzAxm5y3VHH32xWDyTWSdZFHR19YGi
3DL0lZX7udxddM2N2ROwsrR027C/e/tjefmORJbI4sgi76A+Yix2A6eJeTZX
XH+4t7h406Nc4/GECVlRliaDX4lsi/zq5Tc4SRYFLex8Menjj+tq9WBjYxtO
kkVBw+GwSQf72PfCr+iOpwDp4uJifn4B/Qso6Obm9sArK4Z0pudkO0/4X5Ho
6P8sgxM5p3Fqt4c4HMHpt37eIX3VkUasJgi9vLzU/NWRPVnt1vZ6OD09Na2V
VFVNp9PGWgnmrkI9jLqXrgeRw9Y0QdlNk7uS/vKUjEseg+k5GYzj/hduf7n7
ZpA4inRfda5zlnDX7ptPqwhxRkbvCMrq6M/8Js9TMi55DKbntDHu/BdF7iuU
82rovC55W6v/FYdBGR3T+I6QPE6KJxrc/08MRdEXVvP/DEnoL9O3ev4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21632092]
}, Open  ]],

Cell["Add an additional box width between the plots:", "ExampleText",
 CellID->1011512019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data1", ",", "data2", ",", 
   RowBox[{"BoxExtraSpacing", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->194370801],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81PE0EUn3b4UpJSTCSEVHdjiE0MiULUoAlYimJIJCZgSIRobYgGDkaD
nIxJb/bQM4lw6bHhxIXYg4ceiUrCEW78B3LkWN97u6Xdcdv9FLZ0Jt238zq/
95vZN7P7ZmbbmfTa8tv36bWVpbT6dDX9cXll6ZM69WEVvuIhxkLLcNzuZ5Av
M6YdmFbg0LL1c7MgORj8gnMbnJ/Qt3MoeYWnTKUVndVF/Rb0x6aoPUGf9ID6
iaKtqldahlcVBm1PP0/Z8EQ116H7pEPnfAlHiLKXhPq5oCctPILlIUaJ666E
hC1sM2FuBzVhm7FTv9YO123qEkrENtlnsvITivlTdK2/a1HDpGcyGd1P18lv
0Wj0+Pi4whI6ZekRrCdIL5VKiUSigr4SUDSCm6m9zYqWfpZ+bl207JVqvMFJ
Q7sjq84aNHNsLcZ7MSJirMV4/6ghi1VcbdwGb9YUnQ1zLef+M5ufNMuokfdb
UNHSz0FEy16Rfj5LdKfuC2dRyWrN6z2qe2uL9ZzA2xV4s5YxPejtbVa09LMf
aIX0/f39DCWmoOCpVEpVVcyS4Nls9uTkBKF/LJgWFl7HbybGx94xFQUfGZmD
M2YV0ru7I0dHR/8yIdEpw8yzzJfPeyyJgvf1xUwtTOuWludsKfvRX0uMvhg/
xTmLfQbalTCsysUIHiQunM1cs+D4VtafWQlKLIKCx2Ixg14sFnXmYR/bvwEi
Cg9XsilRYhHStQek3/VtCXjjuxg3I6M+o/koHR+fYFpKouDhMD88PHTD5F+b
zp/JznMuS+W7u7v6OFGEcaOCuOG6fV+pfHt7Oxq9Go/fZyoK3tvbD2fMKqRD
YaFQQKjqsaZ8Pn/v7vNqOSjwlWSWzPaZ7dw1GuP6+vrAQBynjEmaN4KSy+X8
aOvm5mYsdsvADJVdDP9KZkvmhw/evFrcYCoK/mI2B2fMKqTD09LjuN7Z+T46
OgYfpqDgQ0N3IpEezKqkT0/P6Csp99cirvC2WoAJ46WWJmkWAnGvpmftMYm/
GKo/NzgrS7M9jOC1snksu3SfWu1R1mdw+gbUP6YfpMPDwbCqYMIqQ/thE0KH
G9Zktius1XBwcGBYJw0ODhp0wNuqwf6ekzfreuuc4OyhyZ3NVkDLXpF+bl30
xe0V3KPDLTr3b0WZY2tvEfGygA6X7bwFNrNy5qXGO5kyirfKHdPMaNkr0s+t
i5a9Uo1mCHYWjbxFUHdR213c9H9+8b99G5yxIe+qoKKln4OIRrC3/2GimA9E
qfG/vCz0F2sxDbo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->202601787]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxLabels",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->335214296],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->16103500],

Cell["Give explicit labels for plots:", "ExampleText",
 CellID->218136693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "4.5", ",", "6", ",", "3", ",", "7", ",", "5"}], "}"}], 
   ",", 
   RowBox[{"BoxLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<data set 1\>\"", ",", "\"\<data set 2\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677379988],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXM1PE0EUn+4UUBOwUpPWkkCBpFACponEFKNSIsIeJCm2CQTU0hATCqIG
SEiMSU/GD+LVxBN3vckf4JGLCSflyJGLSY891nmzu+zu0JXdfuC2vk327fzm
vfebNx+dnd1Mdya7tfJ0PbuVW86GpzeyL1dyy5vhqRcbLIt6CPGssDMWJCxd
IkQ54cixU0mKqVkmvcyMUA75wbFXx4pSMlzNWgCUXd/XgIuqHFM8MwnyklYL
tTqClOBCTyBpFTA1YEi2CPhtHcrwCnpDbbzGkiStDahempbnVa+S2rpGm9ZS
mTrUhfl+xf3A2+Diic9pB9JWg544u5QLQimTJW3c0zJ8kpCn9aaYr9mK7fWu
Rrxi2yhRp4RccdxdFrA41j849Od607hSRvJDNfJu9boj4OmS1Xzz91S7Wsoj
Phe0C9GItf8i4DQTHtd4gpg3aUF5l1sVCgVZlhOJBOlkQorFYn4AlGUyFZj8
tuQd53h/f/87P8gVJqRMJuMHAPmqnTUD1EnK5/MAKFr9t1Zg5KZ40KrWVjD/
w/TttWUtrmrseYl3KtC0MBjhYGHhCVGONAjAqt3PEwbxDi3eJwc5jsfvPF78
/PrVD5ICQRlgWaD6VQcmfuc03fnE1rDPBe0qaZwVMYi9jZ7oeb6e4Oj+KNET
PRvDc42Jq3zFvre3p67kOzk+ODhQOcYd/wJXuf7o6CjBD/50QWgoFBoaGtJx
MpksW4KT+PNcv7S0tLu7C0nr5yBkQiZkajQmO7NN49UKmZCpmZnKPYu7ndnq
HUV1jMb3GID1NxKVMFb6BH+ejPXrITeOdGRCpn/JlOb64+Nj9dltkD+7ybK8
vb0NySjHxWLRwOdsdaWUEI2O9PXFBgZukkEQNBAI9/Ze1/G1YN/a6nMwjVZZ
l1Co+9naN10/8yCvvKxFZmRGZmR2LbM+m/b3RwKBSE/PDZICwWbLCMvSGTs6
fF1dI7re7w9PTNyzE+vo6NjU5CaLkKRAUAZYls4cDHbNJt/o+ltjmbm5xeZo
X2RGZmRG5srnZffHiszIjMzNyFzpmzb7JVS/V6jasvS3m7ncOlEOZb8Vw6ql
spNVlmdM+p2dj4YY7dZH2wn2ledbvYOlZVr9bE9xR7XzsttK+j53Z55Wu+rQ
o7k9wME90aAHepyXxyeeXywWTXuQ9PfYZ+9JMjMdHh6a9h4NDw/H43Eds9jK
MpWLDYD791ijVb2sjKPLDfGgVa2trNbm1v9msLcurY2fMTpYYc+6Lio39ila
4UyHVjhi0KoRrXBcNa6V+Usa2tce7K0T+D8lT31BwugnYjfwwKrsNs8vFAo+
nw88B0BQBk79k955bCDma+Zv/C4Ktegds4fY7061UNoiOz1K0vMHRmpjcQ==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 304},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->679424432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxLineStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47966944],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->183272807],

Cell["Use dashed rather than solid lines in the plot:", "ExampleText",
 CellID->281454388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"BoxLineStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->937938596],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDFs2kAUPWyTsFTtECHUDvEWKUOWtgghteqSVmpaoTaNikSrCkWtyFAR
hVSRqqpEWRiqjgyVEjHStB2qLoipI0slhDqgLM3IyMiY/m9jwMaYA2xjwj/h
O9/3/+fze/8b33H4cXI/9fptcn9nOyk/2Evupna2M/L99B6IRB9jvhRsiRCD
/QvG1O3KBSTYecEwYY2JKFeSUsRh83nq6CFm/nq9/ltLlUqFiYq01Wo5JS2X
y/l83q2zdaSNRoMd6bBAKFQMcrncPS3F4/G2NVg4JY1EIoFAwK2zdaSlUsmA
Qa8/nCr18/NzWZZx9/sUNIExoM9a07mIUPsAiAF800Jg3rBCRcKI/MkOrPyw
J0EpcVss9GiykSwXDZqiob6pWapfP0yADFuXbCyV7nZos7NlrXzeud6A4foE
yPxQfaLIs9ns0tKNlZUwEyCTTo7PpBkomXj69V/7ep5ZXmlvHTV/fHj/h4mf
P/3ts0YfZFJXu9+nrO3RIwWtHVOrjYe78EWutzLGSFf79q1YoVCw1t7UOLx7
5w0afZua5cG7X3ALGMfSDMvBqDipTfw4xw8qEy/e44Xihvjh4weViRfv8UJx
Q/zwxyrxQnFD/JhZ8s0L8PA1XkuDxqRm8yIcI9meuRGs44j/qaXVeOPX4Vb2
YU3xOE/xSPzox8zEi1d4obghfvRP2bFY7NrV68vLN5kAmQRW0gyUo2CSTqfX
1h69THxhAmRKCzNQkp/TfYj48RY/k/wSQLxQ3MwjP8NH2U78om1ur80kMPHk
+Gx9/ZW2doD5s9mfIFI/cICJl0iayRTC4Q0v9sx+qcKmuLoa6YvO4R61hZm/
Wq121m82m832isZLIV3oldZqNVmWBa/0zRUprsfd0nmEaHJn4lu5pbgTt+Vi
+y5obsGzAg0zJ1fB8azE88KKwXnDChUJI/InL2OlKRJG5E/exqp7NyWMyJ8m
OzpoZDsYs+FjEOv/GZiPaIsDbax7yH8WPqSH2/LhNwlD5K/zhhU9e5A/eQWr
4b5IGJE/uY/VOHMI84YR+RMfVupDnZZw/ni0J0xlxln3lGj8r6Oxbmdbh5i5
//6JYrEYCoXcOptuvvtoRLRwRPFRacn1N1REo9FgMDjlN1SM7lP6SJrUXu1g
d9fuEdKoR7EvCdh86q7vP0iX8nU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360980732]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxMedianStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->415016093],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->7036197],

Cell["Display the median line as a dashed line:", "ExampleText",
 CellID->535456913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"BoxMedianStyle", "\[Rule]", "Dashed"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124735122],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDFv00AUx8+xSxmCiKqiBhjqyenUhcIQiYgJFlCEElClwBBVoHRAQaUT
Qk0lhnwGpowRMGSMMjFmQcqYMR8ho8dy7znF9jWJ7MQUW/6f5PM9+/97Pl1e
7PPlLi/qp413H+qnx0d189lJ/WPj+OiT+bR5Ig/pmhBaQ261vJDlCyGc7daF
TLLwRlAiS+h0nBPvDuWmxersOdu2bf/iJAqU6YPBwGN/9dEEO1S/33/CSViU
6cViMZvNUnGP7dFo5LnK/Ot/Z3symZimScWfUEKZGCUJ41w/KNOn3JAlQ+6N
wMQNj1KEIjcVpa7YFban0+nsaVLhp0u3283n81R8JbPXf73dVOiMzDak+ZKP
t1qt7e37hcIjUaFMt6yDnR2TilW2c7k70jFJq0s9Xq2f9Fx6/P7L59/iB2X6
w4Nyp9Pxe6JWFYZLXm2l4L6ovTOXPlfyoEYDSJAgF5MExr+WIEGCjC+JuwhI
kCBxLwAJMn5ksNGI6/W0aDQm5MiDZ3SGbN+oyDWMN6zvIboWTVZMggSJngpI
kCD/P+neC8rlcu72vd3dByIjM0NSRgL2Ydqk2Wzu7z9/W/smMjJjDwnYxyte
QIIEiR4aSJDpItcf8Yhyxsh8X+4oULvdVufGbG3d9c2N6fV6q9XPnRuqzt6p
sj0cDmd6v299TusFm4PEFQtMbs4+qeCEGhVQQrmOkoRxrh+UUCLWoYQS3woo
06Jc9AazfOXA8jeCsCy9oXRjXcN/1ZZJiRIok6HEEwbKtCgR61CmRYlYhzJu
SqdjfJlozWy4vi+vsvX1tNV1t6odpa9ztt01x5byq8Ue27Zte/RhrkXvNGd8
XDry/f9FqVSyLMv9/4vxeLziNbw2ZYeR8c7EW7c475P1E2rcRHuW6lKTm+YU
tT8qM3eX\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379405559]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxOrientation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23015142],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->632882304],

Cell["Orient the graphic horizontally:", "ExampleText",
 CellID->532448870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"BoxOrientation", "\[Rule]", "Horizontal"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90104323],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9rGkEUx2cdaw+BYi4lPy5SUwJRk5BDrkICcU0qXjzlUBWx6qEoaUCI
pf4XySn1j/APyNFLwKNHjx736NHOm51Fne7WjaRoy3dg3sx73zefN84uIuKa
Kd5Wy1+Lt7VSMZK6KTaqtdK3yEX9RoS4wZhRFb25xcR8wpjdqdVEt6fes5iw
QbHgkjzurJywtDABFafRFCPJAeWH5Or4zCrmQqFVLDj1ma9IQKNwGU5o0ZTa
efoVaxxq0Qu31zfHcc7p9134q5CaOWfu89W4k2Oee7ta4qq414h7EJ27xKlo
qpFPZu8WSvVzT6pistFYFt1QyrRmUNvDpuaHV+yvej96fTovwz5UnOIrn2JM
yzpdQNXfJ1+a728X6QWURbp7FTJlKFCgQIECBQqUFSj2p51er/ckG6uT4d1u
V/l70rcsS+U/ulIOHMrGxrv9/VPWIMPD4fc7O1GaSsO3tz6USl8o9ecfKKKg
yP5+98waZPjRYSbzqU3TqPSFc339GRRQQAEFFFBAAQUUUEABZUqh710D/X5/
74W0e5k/HA7FEpq+8aa32+3l6J1Op1AogA466KCDDjrooIMOOuiggw466PN0
xiuVSjKZFEVYlAzP5/O7ux+9q5yf1ROJI0q9l/nZbNY0zUVVms2mXiUSiXtX
ubpsHR+fzFXJ5XL/73UAHXTQQQcddNBBBx100EEHHfS1pFuWtRx9PB6PRiNv
+jr91gEUUEABBRRQQAEFFFBA+fcog8EgFHpL0oPUW60fSnd/7pLMuj5ZCgUK
FChQoECB8jcUitlN+4c74xc2+1mE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 375},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->606601283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxOutliers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->338754245],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->156059432],

Cell["Mark near and far outliers identically:", "ExampleText",
 CellID->57204223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86225238],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW82O0zAQdtZNQb3ArVGLUJRVsxw5ICQqEEgI6IGfTYU4IaRqhdQVINCy
pxU8CCf+qvZOH6DHXpB67LGP0EcIHqfeOk43P43LelNbiTOTb2bsnczG07Hy
rHPcffuhc3x40LGfHHU+dQ8PPtuPPx6RW9hAyOiS07MQoX2EgrPqk0aINoIG
HMJwnzZ6eU5OIzd6lVA75GoKUr9Jh+/f+zY4lbwCt0tLCYRKgs4v0plEp59B
5yfpyil0THL9sYb9df6OdB6S9wyKiTJQjdkUD9X+1d7fVlR7Pw9qLjyI/WBl
Y9f4Fe4yhwK/E8MDKfL5rZkL9umG5lRe+IFKlZdSzFx2a8g8RaXM8BI3w/RP
Ts0o1G+IoqBfSXdjNBohPBwOR7ShBuXH4zEnE346X6iV2Wz2gDbUgA43m81K
pQKkS/lWqzWfz6MW+PF7zJJt20D2teQFlvQoP5lMFpG0TyNpMBhYlgVkm/LT
6ZSTD0eWxyzu7d0mB9qHDrvurVptF0iP8o5zs16/DqLthLlAsJ78JQfqQYff
v/tTq2lNramUZijylZ2l1lRNMyh/sSZmlmdlmOnt04w2VG+Ly4FFHkiRP/+x
r9Ufvnk9JAfqQYdfvey7jUebGBt+QLyg963qHXHMXedu8X2dKobxMobFyM0f
wRfr/1lrZl4txTyxWrVDeaLjuGnGTspZSfbLyauYe2vJ/JJyf9tm/22tQkWg
GCgD1ZjNtqHa+3nQIN1hjYlmq/iL+RjmeBFfJR9fy5ZhPboj8B/mvMxxfZn7
BRSN7BdgKbb5/Ljk6z2EdKh+A2nvbyuqva+9ry4KS3DaSmVYM9iWZ6uoH1lL
UQLvJ6618utgYftZMpqzrEfzJhlW47zO+2MTXlmnAhi2oGak6/dMcVHtfe39
bUW19/PmP+F926S1LvodBNMPev4bCACzrsbRbz9k1Xe+++IXIjhmLnLmHhkB
rV/lWeV53srquo+8bOh86j0wukdOIyCNf2ipzxM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 337},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32965893]
}, Open  ]],

Cell["\<\
Use triangles for near outliers and squares for far outliers:\
\>", "ExampleText",
 CellID->438236984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->166733461],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FrE0EUnmSSNtGCAYWmiUhI27THFkRK8SAImkPVpIgnKYQgtGhQag9F
9Df0bNVaMDZFyUVPOXnsRSg99dif0GOP63tvZ7u7s0l2N9niNpkhOzsv33vf
vL593Xk7Sx5VNlZf1Coba9VK7uF65c3qWvVt7sHrdfiKRxiLrMKxkmYw1hjT
D2xrcOjDIEfjGp3YMsOGEuPGjBr7SPL+/j7T21XseKlUEvg36CJtLbdJnpqa
EpZJsoxGo6enpwjVXSyPjo5slrVaTeCmZQpGUTjHJYZPJC8sLAiGUWJIJpMC
/37OcA3FmGnJWKwtFzgNrptcW1tbPXB9JhmiJ/yKE9fExITA91y4UH/b8Af+
HJMDrpBHDqs/X0je3NwU/nDq5ufnBd7wwbVDciqVElwULLyKDq5OV40Y4mau
MYaR+tExT76STxA9nI3yykVX5BRkEvvZUXOX5Gq1KuTOnNg9DgVqgOHwZthQ
FX0V/WFFVfT7QeMiglzTV0TjLK+MdquEBUU52kXGoSz3zxYX4tIF+TQi4kBa
I6aWQeefjcXP0UA8HLV46P3KhTML1R1iUND3JJ+dnf2hxgrY8WazKeRpkg8O
DoT+B8eV0hmOj4/vUWPT2PHFxcVEIoHDAslQl8MkTgarL3WST05OcrkcDveU
5iXWLJN8eHgoMqlEmdRoNNLpNA6XSYa8sejbM6tsMM7M3IEPK2HHC4Xbmcwk
Dssk5/Nz2ewtVF128QWT9d1f+LA6dvzVy1+ZjLJUlqGytGV+aL1UlmGz1LfX
jCZXmZ2qTe/8VN3a9vO61cOyjENZ/v9z38zeX3n+Gz6sjh1/9nRvdmbpIubG
h4kn9P2N63PynJP5u4Mfa085zM0cljO3/wy+XP/PytL3ainXiePjOVudmM8X
vMztVrNC9WvRD2PtrTT71zSfbSEf5GfbsbEx89m2WCy6PtsiMkvZ02q1bM/W
wG7RCdfuwGCgBhgOb4YNVdHvjuoFjdEMVX/7+3LFxS2yjLfT775zHX5259sF
qYrVgnw7QKjj7QAPhNtaAcc09cYgCFTdgVT0hxVV0VfRDy+KC7TXnUq7pf6K
3lhjNcdKy1xkzXUlDn4fzM7vp87pxO6se4Jg7RZ1azwuIiq97ADaGcKZ6eo+
M7ioir6K/rCiKvoyugvdFRDN37nEqNM0c5fHbUVzchj2em/9JQWCftdcJ3/Q
ezzOGXgXC68zYL2z487Met/paRd5K0v7vZ/+o9PLvo+TxT0X/WtgZ8929LMM
R4SG+IWXX42xyD+KiolV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 350},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->465539633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxOutlierMarkers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->190888486],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->458049097],

Cell["\<\
Use triangles for near outliers and squares for far outliers:\
\>", "ExampleText",
 CellID->524907126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "700", ",", "800", ",", "1100", ",", "1200", ",", "1000", ",", 
     "900", ",", "1000", ",", "2500"}], "}"}], ",", 
   RowBox[{"BoxOutliers", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"BoxOutlierMarkers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      GraphicsBox[
       PolygonBox[{{0.31361111111111, 0.569141111111111}, {0.0202777777777772,
         0.0358077777777774}, {0.611388888888888, 0.0358077777777774}}],
       ImageSize->{19., 16.},
       PlotRange->{{0, 1}, {0, 0.61803}},
       PlotRegion->{{0., 1.57342657342657}, {0., 1.}}], ",", 
      GraphicsBox[RectangleBox[{0, 0}],
       ImageSize->{11., Automatic}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331921556],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FrE0EUnmSSNtGCAYWmiUhI27THFkRK8SAImkPVpIgnKYQgtGhQag9F
9Df0bNVaMDZFyUVPOXnsRSg99dif0GOP63tvZ7u7s0l2N9niNpkhOzsv33vf
vL593Xk7Sx5VNlZf1Coba9VK7uF65c3qWvVt7sHrdfiKRxiLrMKxkmYw1hjT
D2xrcOjDIEfjGp3YMsOGEuPGjBr7SPL+/j7T21XseKlUEvg36CJtLbdJnpqa
EpZJsoxGo6enpwjVXSyPjo5slrVaTeCmZQpGUTjHJYZPJC8sLAiGUWJIJpMC
/37OcA3FmGnJWKwtFzgNrptcW1tbPXB9JhmiJ/yKE9fExITA91y4UH/b8Af+
HJMDrpBHDqs/X0je3NwU/nDq5ufnBd7wwbVDciqVElwULLyKDq5OV40Y4mau
MYaR+tExT76STxA9nI3yykVX5BRkEvvZUXOX5Gq1KuTOnNg9DgVqgOHwZthQ
FX0V/WFFVfT7QeMiglzTV0TjLK+MdquEBUU52kXGoSz3zxYX4tIF+TQi4kBa
I6aWQeefjcXP0UA8HLV46P3KhTML1R1iUND3JJ+dnf2hxgrY8WazKeRpkg8O
DoT+B8eV0hmOj4/vUWPT2PHFxcVEIoHDAslQl8MkTgarL3WST05OcrkcDveU
5iXWLJN8eHgoMqlEmdRoNNLpNA6XSYa8sejbM6tsMM7M3IEPK2HHC4Xbmcwk
Dssk5/Nz2ewtVF128QWT9d1f+LA6dvzVy1+ZjLJUlqGytGV+aL1UlmGz1LfX
jCZXmZ2qTe/8VN3a9vO61cOyjENZ/v9z38zeX3n+Gz6sjh1/9nRvdmbpIubG
h4kn9P2N63PynJP5u4Mfa085zM0cljO3/wy+XP/PytL3ainXiePjOVudmM8X
vMztVrNC9WvRD2PtrTT71zSfbSEf5GfbsbEx89m2WCy6PtsiMkvZ02q1bM/W
wG7RCdfuwGCgBhgOb4YNVdHvjuoFjdEMVX/7+3LFxS2yjLfT775zHX5259sF
qYrVgnw7QKjj7QAPhNtaAcc09cYgCFTdgVT0hxVV0VfRDy+KC7TXnUq7pf6K
3lhjNcdKy1xkzXUlDn4fzM7vp87pxO6se4Jg7RZ1azwuIiq97ADaGcKZ6eo+
M7ioir6K/rCiKvoyugvdFRDN37nEqNM0c5fHbUVzchj2em/9JQWCftdcJ3/Q
ezzOGXgXC68zYL2z487Met/paRd5K0v7vZ/+o9PLvo+TxT0X/WtgZ8929LMM
R4SG+IWXX42xyD+KiolV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 350},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->409699246]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxQuantile",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23643794],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->33888893],

Cell["The default covers the middle 50% of the data:", "ExampleText",
 CellID->204799523],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "1000"}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->597942307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153527058],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0FPGkEUfsugtCRGbhJM6oaDWpN6MXogKemp5UKCYpqg8UBMG0xrMOqp
aYKXnjl74ia0x/ID+ANN+An8FPveLMRlWnRnEZhd3mTn7czu997OfjvDm7fL
5MvXlU/n5euz07L94bJ8UTk7vbLfVy/xkLAArArmUhKwfA/g5OV7TFg4AkpU
A0HHZZK7j5gto87eoHjd6XRAtNvtjkywLuvdbteFedAm5Zq00uv13skE6yRE
JpOJx+NU3JD1QqHwXwvu67cGlmzbpuIvRmojCWhy+8KHnDfGF/v3vOhZ46WC
FJ41HaiTIpijvi3FsBTpt3oB93cjkS8Um+o1J3Gf+pwGpbfwWGIe5wHJjDPj
piDJi0Rxv+BZI+ZCgpam6qFVn0fe83F/699rjudvIfqA1OVqMJMIQm/gUWU2
khlnxsOOnDfGY/179u5V/EedXjyw/zZMKlb2rxlu/8tjapbIoqzX6/WaTHBA
QlSr1UQiQcVDWW80Gi788BMpDixm337GDYokxN5uqV8/cOp7R6nUK4IePtEW
rH//9gc3aJEQX7/8Zs0paw49V2NbyZrcA8KvSfMG8v7qzMq7BfmuYyj2V+ce
49qiOdO+Qe2ZuK21tR3coEVCrK6+WVpa1nxqJ8e3uEGLhNgv/FhZSc2+r/Gv
DWtyD2BN7gHT0Nza2gYn/SQhcrm867yJ0SLH5+obHQJO4/8Sz6tp3vepUfMl
U589j6GwIJlx5jGYSGZ8FJIieQrk/X2dAS1Nff8aVzQinq/lX/Ppdxvz6pt5
FDHjYUcy48y4af//mIUXdHuyScXA4/loPQ6D0jt47JiNZMaZ8WAiCXiD+025
arfZbCaTSSpuPLqK122/NrA/tJo3m82m02m91bwkzFvj/O9Ziv5KmC2naP0F
NTxW7A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263834020]
}, Open  ]],

Cell["Cover the middle 90%:", "ExampleText",
 CellID->241892751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"BoxQuantile", "\[Rule]", ".45"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->408227493],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMFq20AQXXmdOBaEHG0caIQOcnsoFFzaYIjpqT0VHNttiUsLJhQc2tLi
hh5KIbmk1577A7Xpsf4A/0BBn+BPSWfWMlEUy9bKFtm1Ztld7drvjaTRSDO7
Xut557T77mPn9OS4Yz3rdT53T46/WE8/9eAjbjBmdKEcFRm0LxmblJ1LSNBo
M0zYYxw/F0lsXkIxlPr2HKp7o9GI8eFwOBKJOaLvuq4Pc8VG8pmQMh6Pn4jE
HKx4tVo1TRObZdGv1+szJfj3P5hKsiwLm38IKY1EoMrHt37ItGl80zvnzciM
fADJIzMn0EnKQMnGlpSDVsY76g3Y/g5FbgVkBveZxHnK61QXa6F7ifSYBiRp
nDSuChK9SBa2G5EZOR+SSTGDHjro89B7zve38b3mcv6WZa+QsrqaRhI6WAPd
VWojddJ4U/Rd1/VmBxpidqDf7xeLRWy2RB8k+fDzJEG/XH4EmTWw4o7zsFCw
sNkUfdt+YNsOQluLJX3/9g8yG2DFP7z/WyrdUYOJQPWPkphkAbowc55Og147
uoRFo/zokqJEQKs7RoylDm/hLFcnKSx+Utvi9GPSMyftTLKA9WDSdUw7kyxA
FSbGQRi9xI88xVzbtbmn5WKpm7LkYsTkjydxWXt7FchsgBXf3b2/vb0jedXe
vP4FmQ2w4of1i0KhdPu2Rk8bYpIFEJMsgJhkAboztzydxo+IFv3eqYokufhT
xbNaPsrXyzbpGUNMsgBirug6eqPpphhNv3rx0+s3vNH1j4j7brff7u8fQGYN
rHil8jifN7HZEv1e76sPP1uSLisraN2JOkicecKJp+grv/2/jjIpZlj8FL5e
zgwwMpH3FZ+5eC5uvm5mxVKqXn26i9RGksZJ4+uOTJvGw9ZzJeHL4jP9niyp
Ne3L+Wg5HepiHXTvqI0kjZPG9UQi8By2dwP/YyjPfeuBX/7ZVP61tx/UajXb
tuXefoCVeu+EuPktjv6OoBiTpvEfhgiyHQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 345},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->160310972]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BoxFillingStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->94974067],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->430360757],

Cell["Use a light gray to shade the box:", "ExampleText",
 CellID->322506763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BoxWhiskerPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "3", ",", "2", ",", "5", ",", "6", ",", "5", ",", "10"}], "}"}],
    ",", 
   RowBox[{"BoxFillingStyle", "\[Rule]", 
    RowBox[{"GrayLevel", "[", ".8", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224582190],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9v2kAUx88xaTrQEcSPxZObHcQAEurULlSoglaRUgmhqIgMVas0EluJ
1IGVlYkRlQ6MiKkjCxIjI38Co8f03pnU9gWQDW5q5O9JPt4z38+7y3HYd5cz
b+u3zU+f67fXV3XtzU39a/P66pv2+ssNP6UqjClNflwmGLfvGTOPF/c8ceMj
o0QeU+m8SOLlgh9KoN69E75hGL9FYi8pUyeTic3/4aAJNqnxePxKJKZTpubz
+Wg0Sua58Ofzua2UzeX/FP5yudQ0jcxfUEJ5NEoSBrl+UIZPecqtCH+NuCae
2ZTME3kmKVXJrwh/tVqt7yYVcXcZDAaJRILM9zz78Dfac4k+4dkpd9+J8+12
O51O53I5VqFMzWazvD5kVoUfi8V4YJJWd0Z8XD8eudFozGYzNqRMLZfL/X7f
GYlalUUs8nEruY9F7X3yEHOvCHJvAAkS5HaSwODXEiRIkMElcRUBCRIkrgUg
QQaPdLca8bSRtq3GeFx5sK3OkO9YFXmC9YbDI/jXosfVJ0GCxEgFJEiQ/5+0
rgW1Wi2VSmUyGTakTI3H491u101ZrVarVCr1ej02pEwtFAqB+ftAggSJEQVI
kOEiD5+h+7nDYXMsa9Wi0+nIezmSyaRjL8doNNqvftZeRnm3SVX40+l0rXfG
Vje0nrs9M6Jirsmz9SflnpB7BZRQHqIkYZDrByWU6OtQQolvBZRhUW6bweze
6b57RuCVpRnKINA1/FdteSy9BMrjUOIOA2VYlOjrUIZFib4OZdCU5sD4IdEz
nt7GvuKpUMdIW35OVPb9jHUnfOsZWV36r8W58A3DsOm9lEVzmu/iPA/k+L2G
YrGo67r1ew2LxWLPMuw+ZRe+8eZGUcvc9Mk6Cbnf+Psu1eWSH4ppKn8A4JYN
Mw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 347},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170171435]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26222],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StemLeafPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParetoPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29331]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30974],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->3447]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BoxWhiskerPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 26.6153062}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "BoxWhiskerPlot[data] creates a box-and-whisker plot of the given vector \
of data. BoxWhiskerPlot[data_1, data_2, ...] creates multiple box-and-whisker \
plots. BoxWhiskerPlot[matrix] also creates multiple box-and-whisker plots, \
with each column of the matrix used for a separate box.", "synonyms" -> {}, 
    "title" -> "BoxWhiskerPlot", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/BoxWhiskerPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10326, 341, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239878629]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43628, 1307}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1379, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2002, 63, 52, 1, 70, "ObjectName",
 CellID->24408],
Cell[2057, 66, 1332, 40, 70, "Usage",
 CellID->4415]
}, Open  ]],
Cell[CellGroupData[{
Cell[3426, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3904, 128, 304, 6, 70, "Notes",
 CellID->1908],
Cell[4211, 136, 109, 3, 70, "Notes",
 CellID->170298398],
Cell[4323, 141, 227, 8, 70, "Notes",
 CellID->17223],
Cell[4553, 151, 279, 7, 70, "Notes",
 CellID->11759],
Cell[4835, 160, 291, 9, 70, "Notes",
 CellID->26434],
Cell[5129, 171, 3151, 81, 70, "3ColumnTableMod",
 CellID->5204],
Cell[8283, 254, 403, 14, 70, "Notes",
 CellID->9091],
Cell[8689, 270, 335, 13, 70, "Notes",
 CellID->5945],
Cell[9027, 285, 584, 23, 70, "Notes",
 CellID->26806],
Cell[9614, 310, 382, 14, 70, "Notes",
 CellID->18434],
Cell[9999, 326, 290, 10, 70, "Notes",
 CellID->28532]
}, Closed]],
Cell[CellGroupData[{
Cell[10326, 341, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239878629],
Cell[CellGroupData[{
Cell[10711, 355, 147, 5, 70, "ExampleSection",
 CellID->55794319],
Cell[10861, 362, 141, 4, 70, "Input",
 CellID->270068752],
Cell[11005, 368, 94, 1, 70, "ExampleText",
 CellID->57666891],
Cell[CellGroupData[{
Cell[11124, 373, 246, 7, 28, "Input",
 CellID->131691384],
Cell[11373, 382, 1140, 23, 372, "Output",
 Evaluatable->False,
 CellID->585639235]
}, Open  ]],
Cell[12528, 408, 115, 3, 70, "ExampleText",
 CellID->105930128],
Cell[12646, 413, 449, 16, 70, "Input",
 CellID->3484384],
Cell[CellGroupData[{
Cell[13120, 433, 141, 4, 28, "Input",
 CellID->374492077],
Cell[13264, 439, 1327, 26, 324, "Output",
 Evaluatable->False,
 CellID->914477369]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14640, 471, 218, 7, 70, "ExampleSection",
 CellID->14776],
Cell[CellGroupData[{
Cell[14883, 482, 231, 7, 70, "ExampleSubsection",
 CellID->9220],
Cell[15117, 491, 141, 4, 70, "Input",
 CellID->415961335],
Cell[15261, 497, 89, 1, 70, "ExampleText",
 CellID->53154001],
Cell[15353, 500, 450, 16, 70, "Input",
 CellID->73404589],
Cell[CellGroupData[{
Cell[15828, 520, 141, 4, 70, "Input",
 CellID->227635225],
Cell[15972, 526, 1427, 27, 70, "Output",
 Evaluatable->False,
 CellID->21632092]
}, Open  ]],
Cell[17414, 556, 90, 1, 70, "ExampleText",
 CellID->1011512019],
Cell[CellGroupData[{
Cell[17529, 561, 195, 5, 70, "Input",
 CellID->194370801],
Cell[17727, 568, 1510, 29, 70, "Output",
 Evaluatable->False,
 CellID->202601787]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19286, 603, 230, 7, 70, "ExampleSubsection",
 CellID->335214296],
Cell[19519, 612, 140, 4, 70, "Input",
 CellID->16103500],
Cell[19662, 618, 74, 1, 70, "ExampleText",
 CellID->218136693],
Cell[CellGroupData[{
Cell[19761, 623, 473, 15, 70, "Input",
 CellID->677379988],
Cell[20237, 640, 1616, 31, 70, "Output",
 Evaluatable->False,
 CellID->679424432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21902, 677, 232, 7, 70, "ExampleSubsection",
 CellID->47966944],
Cell[22137, 686, 141, 4, 70, "Input",
 CellID->183272807],
Cell[22281, 692, 90, 1, 70, "ExampleText",
 CellID->281454388],
Cell[CellGroupData[{
Cell[22396, 697, 288, 9, 70, "Input",
 CellID->937938596],
Cell[22687, 708, 1400, 27, 70, "Output",
 Evaluatable->False,
 CellID->360980732]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24136, 741, 235, 7, 70, "ExampleSubsection",
 CellID->415016093],
Cell[24374, 750, 139, 4, 70, "Input",
 CellID->7036197],
Cell[24516, 756, 84, 1, 70, "ExampleText",
 CellID->535456913],
Cell[CellGroupData[{
Cell[24625, 761, 290, 9, 70, "Input",
 CellID->124735122],
Cell[24918, 772, 1136, 23, 70, "Output",
 Evaluatable->False,
 CellID->379405559]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26103, 801, 234, 7, 70, "ExampleSubsection",
 CellID->23015142],
Cell[26340, 810, 141, 4, 70, "Input",
 CellID->632882304],
Cell[26484, 816, 75, 1, 70, "ExampleText",
 CellID->532448870],
Cell[CellGroupData[{
Cell[26584, 821, 293, 9, 70, "Input",
 CellID->90104323],
Cell[26880, 832, 1034, 21, 70, "Output",
 Evaluatable->False,
 CellID->606601283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27963, 859, 232, 7, 70, "ExampleSubsection",
 CellID->338754245],
Cell[28198, 868, 141, 4, 70, "Input",
 CellID->156059432],
Cell[28342, 874, 81, 1, 70, "ExampleText",
 CellID->57204223],
Cell[CellGroupData[{
Cell[28448, 879, 325, 9, 70, "Input",
 CellID->86225238],
Cell[28776, 890, 1228, 24, 70, "Output",
 Evaluatable->False,
 CellID->32965893]
}, Open  ]],
Cell[30019, 917, 112, 3, 70, "ExampleText",
 CellID->438236984],
Cell[CellGroupData[{
Cell[30156, 924, 807, 20, 70, "Input",
 CellID->166733461],
Cell[30966, 946, 1514, 29, 70, "Output",
 Evaluatable->False,
 CellID->465539633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32529, 981, 238, 7, 70, "ExampleSubsection",
 CellID->190888486],
Cell[32770, 990, 141, 4, 70, "Input",
 CellID->458049097],
Cell[32914, 996, 112, 3, 70, "ExampleText",
 CellID->524907126],
Cell[CellGroupData[{
Cell[33051, 1003, 807, 20, 70, "Input",
 CellID->331921556],
Cell[33861, 1025, 1514, 29, 70, "Output",
 Evaluatable->False,
 CellID->409699246]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35424, 1060, 231, 7, 70, "ExampleSubsection",
 CellID->23643794],
Cell[35658, 1069, 140, 4, 70, "Input",
 CellID->33888893],
Cell[35801, 1075, 89, 1, 70, "ExampleText",
 CellID->204799523],
Cell[35893, 1078, 256, 9, 70, "Input",
 CellID->597942307],
Cell[CellGroupData[{
Cell[36174, 1091, 113, 3, 70, "Input",
 CellID->153527058],
Cell[36290, 1096, 1136, 23, 70, "Output",
 Evaluatable->False,
 CellID->263834020]
}, Open  ]],
Cell[37441, 1122, 64, 1, 70, "ExampleText",
 CellID->241892751],
Cell[CellGroupData[{
Cell[37530, 1127, 178, 5, 70, "Input",
 CellID->408227493],
Cell[37711, 1134, 1225, 24, 70, "Output",
 Evaluatable->False,
 CellID->160310972]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38985, 1164, 235, 7, 70, "ExampleSubsection",
 CellID->94974067],
Cell[39223, 1173, 141, 4, 70, "Input",
 CellID->430360757],
Cell[39367, 1179, 77, 1, 70, "ExampleText",
 CellID->322506763],
Cell[CellGroupData[{
Cell[39469, 1184, 325, 10, 70, "Input",
 CellID->224582190],
Cell[39797, 1196, 1132, 23, 70, "Output",
 Evaluatable->False,
 CellID->170171435]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41002, 1227, 311, 9, 70, "SeeAlsoSection",
 CellID->26222],
Cell[41316, 1238, 497, 17, 70, "SeeAlso",
 CellID->29331]
}, Open  ]],
Cell[CellGroupData[{
Cell[41850, 1260, 314, 9, 70, "TutorialsSection",
 CellID->30974],
Cell[42167, 1271, 171, 4, 70, "Tutorials",
 CellID->3447]
}, Open  ]],
Cell[42353, 1278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

