(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10637,        366]
NotebookOptionsPosition[      8079,        281]
NotebookOutlinePosition[      9340,        317]
CellTagsIndexPosition[      9256,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IncludeStemCounts" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemCounts"], 
          "IncludeStemUnits" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemUnits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IncludeStemCounts\"\>", 
       2->"\<\"IncludeStemUnits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ColumnLabels", "ObjectName",
 CellID->21718],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ColumnLabels"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " which specifies the labels for columns."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for the option ",
 Cell[BoxData["ColumnLabels"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a list of labels."
}], "Notes",
 CellID->16139],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  RowBox[{"ColumnLabels", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the stem column is labeled ",
 Cell[BoxData["Stem"], "InlineFormula"],
 ", leaf columns are labeled ",
 Cell[BoxData["Leaves"], "InlineFormula"],
 ", and count columns are labeled ",
 Cell[BoxData["Counts"], "InlineFormula"],
 "."
}], "Notes",
 CellID->23471297],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ColumnLabels", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["label", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["label", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", the number of labels should match the number of columns, with labels \
placed on the plot sequentially from left to right."
}], "Notes",
 CellID->12423]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99944914],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->863250120],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->111559827],

Cell["Label stem and leaf columns with \"S\" and \"L\":", "ExampleText",
 CellID->755057619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<S\>\"", ",", "\"\<L\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41451835],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNGE1LwzA0a9LOORTBi3hxZ0Fx6kVB2DwoCP6C4aEMYTuIMvf/Y5Im7evL
a5uum6zQJe/lfeV9Jd17ul58fqXr5Twdva7Sn8Vy/jt6+V4pFO8xxmbq/Thj
ai7VzLwzKdUIfxnPBv0bqTFWE27RghXr+onVO1BghPCcWUbmHj3X1MJKi6w0
YbmHatTrvZINzFIaVumeXBm3gtWTAKoCOwBUbj+0PIEojfw+ooK6BVzTco+Q
hGwnMaktRrSi2nqPt4X9AO4j+KSltTHSvBsrXXacktZFdpWUUmtBiLV5bsB8
abCX1sxlXUbA+nKe5bKoCs7KNAfAtih3oiuqCHALIE002yFyHUAOpLtG8Hll
VCJk8xWivIAamN9zwn+PkeS3GqzLJpz7zusTmec8WE0QjLknpSiagBA66rkk
kVtheg1X0XvU5CCID/fLXXK5no6pE4t/bh3J/8W6KsSnR2Lx09axpPtqWP7t
itd1h/pddtGwLQ+FxWMfMofG4psRVReuf7ublh7vt+RF+izGkR3nvoZY7HMD
l/oPdYZD+EbiTqKn2AcVcku3LA3cmkWsA/ch51F4EvoeyGQ1ZTiGyf1WyG4T
OwyH3XIyPXUV4m7ZMLPu5L7UxmYVg+9NjzIkx9pUx0OQRDI3NpSFc7iLXQb2
aifMS34lPnXwLubKbHB3xkPCn5wV35zZbttkzqVCjFtzbS9jTeSISizfOb3v
26a+UIpH2NnfiQ/A0zxiVR3Gp4beGIZxeF8jTbVW2IW/Pqj7vgaze6f9l6P3
Bzug1ec=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61341403]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22549],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemUnits",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17437]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16279],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->25996]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ColumnLabels - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 27.0528174}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "ColumnLabels is an option for StemLeafPlot which specifies the labels \
for columns.", "synonyms" -> {}, "title" -> "ColumnLabels", "type" -> 
    "Symbol", "uri" -> "StatisticalPlots/ref/ColumnLabels"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4445, 155, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->99944914]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9114, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1423, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2046, 64, 50, 1, 70, "ObjectName",
 CellID->21718],
Cell[2099, 67, 533, 16, 70, "Usage",
 CellID->3753]
}, Open  ]],
Cell[CellGroupData[{
Cell[2669, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3147, 105, 284, 10, 70, "Notes",
 CellID->16139],
Cell[3434, 117, 463, 15, 70, "Notes",
 CellID->23471297],
Cell[3900, 134, 508, 16, 70, "Notes",
 CellID->12423]
}, Closed]],
Cell[CellGroupData[{
Cell[4445, 155, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99944914],
Cell[CellGroupData[{
Cell[4829, 169, 148, 5, 70, "ExampleSection",
 CellID->863250120],
Cell[4980, 176, 141, 4, 70, "Input",
 CellID->111559827],
Cell[5124, 182, 92, 1, 70, "ExampleText",
 CellID->755057619],
Cell[CellGroupData[{
Cell[5241, 187, 362, 11, 28, "Input",
 CellID->41451835],
Cell[5606, 200, 1011, 21, 114, "Output",
 Evaluatable->False,
 CellID->61341403]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6678, 228, 311, 9, 70, "SeeAlsoSection",
 CellID->22549],
Cell[6992, 239, 519, 17, 70, "SeeAlso",
 CellID->17437]
}, Open  ]],
Cell[CellGroupData[{
Cell[7548, 261, 314, 9, 70, "TutorialsSection",
 CellID->16279],
Cell[7865, 272, 172, 4, 70, "Tutorials",
 CellID->25996]
}, Open  ]],
Cell[8052, 279, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

