(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13808,        456]
NotebookOptionsPosition[     11180,        369]
NotebookOutlinePosition[     12454,        405]
CellTagsIndexPosition[     12369,        400]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataSpacing" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataSpacing"],
           "DataTicks" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataTicks"], 
          "DataLabels" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataLabels"], 
          "PlotDirection" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/PlotDirection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DataSpacing\"\>", 2->"\<\"DataTicks\"\>", 
       3->"\<\"DataLabels\"\>", 
       4->"\<\"PlotDirection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataRanges", "ObjectName",
 CellID->330],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DataRanges"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PairwiseScatterPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
      "InlineFormula"],
     " which specifies range limits for each column of data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31923]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DataRanges"], "InlineFormula"],
 " restricts the points to be plotted."
}], "Notes",
 CellID->28350],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or a list of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["min", "TI"], ",", 
    StyleBox["max", "TI"]}], "}"}]], "InlineFormula"],
 " pairs, used cyclically for the columns of data. "
}], "Notes",
 CellID->145571045],

Cell["\<\
A single range setting can be given, in which case all of the columns receive \
the same range specification.\
\>", "Notes",
 CellID->14333],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"DataRanges", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["r", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", the subplot comparing the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], "th"]], "InlineFormula"],
 " column of data to the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["j", "TI"], "th"]], "InlineFormula"],
 " column effectively receives a ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["j", "TI"]], ",", 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22925]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8735532],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->36716635],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->965434770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PairwiseScatterPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
  "InlineFormula"],
 " with the range of data values limited:"
}], "ExampleText",
 CellID->299346622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRanges", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"DataTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145812446],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 368},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170035127]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1278],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataLabels"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotDirection",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10910],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->19737]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataRanges - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 27.4590778}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "DataRanges is an option for PairwiseScatterPlot which specifies range \
limits for each column of data.", "synonyms" -> {}, "title" -> "DataRanges", 
    "type" -> "Symbol", "uri" -> "StatisticalPlots/ref/DataRanges"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5233, 185, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8735532]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12228, 393}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 68, 46, 1, 70, "ObjectName",
 CellID->330],
Cell[2323, 71, 560, 16, 70, "Usage",
 CellID->31923]
}, Open  ]],
Cell[CellGroupData[{
Cell[2920, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3398, 109, 131, 4, 70, "Notes",
 CellID->28350],
Cell[3532, 115, 512, 19, 70, "Notes",
 CellID->145571045],
Cell[4047, 136, 150, 4, 70, "Notes",
 CellID->14333],
Cell[4200, 142, 996, 38, 70, "Notes",
 CellID->22925]
}, Closed]],
Cell[CellGroupData[{
Cell[5233, 185, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8735532],
Cell[CellGroupData[{
Cell[5616, 199, 147, 5, 70, "ExampleSection",
 CellID->36716635],
Cell[5766, 206, 141, 4, 70, "Input",
 CellID->965434770],
Cell[5910, 212, 258, 8, 70, "ExampleText",
 CellID->299346622],
Cell[CellGroupData[{
Cell[6193, 224, 741, 24, 47, "Input",
 CellID->145812446],
Cell[6937, 250, 2270, 41, 389, "Output",
 Evaluatable->False,
 CellID->170035127]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9268, 298, 310, 9, 70, "SeeAlsoSection",
 CellID->1278],
Cell[9581, 309, 1031, 35, 70, "SeeAlso",
 CellID->31172]
}, Open  ]],
Cell[CellGroupData[{
Cell[10649, 349, 314, 9, 70, "TutorialsSection",
 CellID->10910],
Cell[10966, 360, 172, 4, 70, "Tutorials",
 CellID->19737]
}, Open  ]],
Cell[11153, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

