(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10455,        355]
NotebookOptionsPosition[      7953,        272]
NotebookOutlinePosition[      9223,        308]
CellTagsIndexPosition[      9139,        303]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DataRanges" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataRanges"], 
          "DataTicks" :> 
          Documentation`HelpLookup["paclet:StatisticalPlots/ref/DataTicks"], 
          "DataLabels" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/DataLabels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DataRanges\"\>", 2->"\<\"DataTicks\"\>", 
       3->"\<\"DataLabels\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataSpacing", "ObjectName",
 CellID->13882],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DataSpacing"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["PairwiseScatterPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
      "InlineFormula"],
     " which specifies spacing between the subplots."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["DataSpacing"], "InlineFormula"],
 " are a single number or a list of two numbers, specifying the amount of \
horizontal and vertical spacing to apply between subplots."
}], "Notes",
 CellID->28315],

Cell[TextData[{
 "The numbers are scaled such that a setting of ",
 Cell[BoxData["1"], "InlineFormula"],
 " corresponds to the size of one of the subplots."
}], "Notes",
 CellID->4575]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68349613],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->202968237],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->342185],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PairwiseScatterPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PairwiseScatterPlot"]], 
  "InlineFormula"],
 " with non\[Hyphen]zero spacing between plots:"
}], "ExampleText",
 CellID->299346622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataSpacing", "\[Rule]", ".1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145812446],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2zFv2kAUwPFDTlqGdu+SyEs7e8neqWGpxNYVFFU1QxSUZEgm0omRuV0Q
LIyMjHwERkZGPgJj+u4uyisnJJ9Rqprob8nWnd/z7xnOw1k6f23f5t8v27ed
i3Z6ft3u5p2Lm/TL1bWcSmrG1HLZf3ww0n40xu9268jum+Vab+0xGQwGn91m
RvaQNBqN1WplQ+9dfL1eyykbGrt4v993VR/N8V+KhASaz+dmZA9WGQ6HqsjJ
LMs0PplM0jS1oTfbikRtc+T6rVYrVCRF43KjKHsoR64vIymPUJ7n5neBujs/
roqkyFX1ej2ySpgfV2U2m8kpgSOrhPmHNHooKCgoKCgo1VXOXF9nTZ0C9WOQ
f1+iis6a4qpofpkqOmuKq6L5cVWqNHooKCgoKCgoKCgoKCj7KQ+ur+92pwXq
tyD/vEQVfbeLq6L5Zarou11cFc2Pq1Kl0UNBQUFBQUGprvLL9XXWdFyg3gX5
n0pU0VlTXBXNL1NFZ01xVTQ/rkqVRg8FBQUFBQWlusqJ6+us6WeBuntWFldF
Z01xVcJZWVwVnTXFVQlnZYc0eq9IkQt7vZ4Z2UOSZVmoyFUa73a7OxTJ6rnt
KUue0s1mo4p05JQNjV3c37gN+dXvtrnv+vt/1/K/rdlsGr+N7SGZTqdP9/7O
xReLxVZc/sGt31bJMX+1CmvyWZOPgoKCgsK7CO8iKCgoKCgvrfBlEl8moaCg
oKCgoKCgoKCgoKCgoKCgHK7y4Pp8bzvke1sUFBQUlEKF7yf5fvL/K3KV8Ztf
l+5JG/Lr1pfLpX0MnuOetKGXXJNvan8AT1ETyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9013630]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19897],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRanges",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataRanges"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/DataLabels"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31172]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9567],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->22336]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 27.6778334}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "DataSpacing is an option for PairwiseScatterPlot which specifies spacing \
between the subplots.", "synonyms" -> {}, "title" -> "DataSpacing", "type" -> 
    "Symbol", "uri" -> "StatisticalPlots/ref/DataSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3717, 124, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68349613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8997, 296}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1500, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2123, 65, 49, 1, 70, "ObjectName",
 CellID->13882],
Cell[2175, 68, 551, 16, 70, "Usage",
 CellID->540]
}, Open  ]],
Cell[CellGroupData[{
Cell[2763, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3241, 106, 252, 6, 70, "Notes",
 CellID->28315],
Cell[3496, 114, 184, 5, 70, "Notes",
 CellID->4575]
}, Closed]],
Cell[CellGroupData[{
Cell[3717, 124, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68349613],
Cell[CellGroupData[{
Cell[4101, 138, 148, 5, 70, "ExampleSection",
 CellID->202968237],
Cell[4252, 145, 138, 4, 70, "Input",
 CellID->342185],
Cell[4393, 151, 264, 8, 70, "ExampleText",
 CellID->299346622],
Cell[CellGroupData[{
Cell[4682, 163, 525, 17, 28, "Input",
 CellID->145812446],
Cell[5210, 182, 1044, 21, 380, "Output",
 Evaluatable->False,
 CellID->9013630]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6315, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->19897],
Cell[6629, 221, 757, 26, 70, "SeeAlso",
 CellID->31172]
}, Open  ]],
Cell[CellGroupData[{
Cell[7423, 252, 313, 9, 70, "TutorialsSection",
 CellID->9567],
Cell[7739, 263, 172, 4, 70, "Tutorials",
 CellID->22336]
}, Open  ]],
Cell[7926, 270, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

