(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10678,        364]
NotebookOptionsPosition[      8120,        280]
NotebookOutlinePosition[      9443,        317]
CellTagsIndexPosition[      9359,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StemExponent" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/StemExponent"], "IncludeEmptyStems" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeEmptyStems"], 
          "IncludeStemCounts" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/IncludeStemCounts"], "ColumnLabels" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/ColumnLabels"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StemExponent\"\>", 
       2->"\<\"IncludeEmptyStems\"\>", 3->"\<\"IncludeStemCounts\"\>", 
       4->"\<\"ColumnLabels\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IncludeStemUnits", "ObjectName",
 CellID->29200],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IncludeStemUnits"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["StemLeafPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:StatisticalPlots/ref/StemLeafPlot"]], 
      "InlineFormula"],
     " which specifies whether the units of the stems should be included with \
the plot."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21318],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  RowBox[{"IncludeStemUnits", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the base unit is displayed below the stem\[Hyphen]and\[Hyphen]leaf plot."
}], "Notes",
 CellID->16858]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83865753],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->7583714],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->162166843],

Cell["Omit stem units legend from plot:", "ExampleText",
 CellID->79125152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"IncludeStemUnits", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276048965],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tPwzAMTvMojzOPggANwTjyM0AcdtsfqCak7YBAY/8/xEmTpp7bpa2o
NmlJ7diOY39200W5W39+lbvNqpy9b8uf9Wb1O3v73hqWyBhjS/P/KJh51ubJ
/pdam/kJRgG0/bHXDu6NGYF5glaVGZQhn63ULVrNEY21ndaVGXPCdrs0U4Fr
eYydJulewyhrbqpeEXHTdxumBZHmhHRe8V96525aLsQYmGeE/0DOe2RRkVJp
WPsv3aLKQ/f5xuwwPjZpOTgGtNBciIBqqQEgZTWLai5Gx42TXIV0L0N0Yy6O
sqUbXUYgCYnoC437BTxiz1vsythrIGwcbB/p6jY+lqLSEmQEnK1DaMY0ed4W
22lZwzvgCHZ531UNkkCTze9R1EG/6vDvYn+OB52Cqj71cJ9kkUTDQFsYtWP8
svRetaRFab/2HkdEF9eH8wFwB2+WcyKeoupGIpy2D2LgCjg1St0h3eWHR977
fuPXbZ9l7TfLuD8pInZ+nUdz0zqNmdgO0HkkVXNJbDdwwJEE3evwbmkdMrMz
jSH8bootTO8/7JMleKxQPg54ivIc44HOKtfNHujQwHV9bzjcmYb7l9pHx3Nd
nOMaw93fnzmWSXmrxverYEPqUE3NaMraFxn20a6PYYzgexPefR5yxZHfd0jS
9xL3LeS+Zln2B/NWxao=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{84, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291929738]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11903],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StemExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/StemExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeEmptyStems",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IncludeStemCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24050],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->24155]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IncludeStemUnits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 28.4747288}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "IncludeStemUnits is an option for StemLeafPlot which specifies whether \
the units of the stems should be included with the plot.", "synonyms" -> {}, 
    "title" -> "IncludeStemUnits", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/IncludeStemUnits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4131, 140, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->83865753]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9217, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1710, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2333, 69, 54, 1, 70, "ObjectName",
 CellID->29200],
Cell[2390, 72, 582, 17, 70, "Usage",
 CellID->21080]
}, Open  ]],
Cell[CellGroupData[{
Cell[3009, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3487, 111, 307, 13, 70, "Notes",
 CellID->21318],
Cell[3797, 126, 297, 9, 70, "Notes",
 CellID->16858]
}, Closed]],
Cell[CellGroupData[{
Cell[4131, 140, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83865753],
Cell[CellGroupData[{
Cell[4515, 154, 146, 5, 70, "ExampleSection",
 CellID->7583714],
Cell[4664, 161, 141, 4, 70, "Input",
 CellID->162166843],
Cell[4808, 167, 75, 1, 70, "ExampleText",
 CellID->79125152],
Cell[CellGroupData[{
Cell[4908, 172, 304, 9, 28, "Input",
 CellID->276048965],
Cell[5215, 183, 902, 19, 94, "Output",
 Evaluatable->False,
 CellID->291929738]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6178, 209, 311, 9, 70, "SeeAlsoSection",
 CellID->11903],
Cell[6492, 220, 1060, 35, 70, "SeeAlso",
 CellID->2168]
}, Open  ]],
Cell[CellGroupData[{
Cell[7589, 260, 314, 9, 70, "TutorialsSection",
 CellID->24050],
Cell[7906, 271, 172, 4, 70, "Tutorials",
 CellID->24155]
}, Open  ]],
Cell[8093, 278, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

