(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64396,       1684]
NotebookOptionsPosition[     57955,       1457]
NotebookOutlinePosition[     59280,       1494]
CellTagsIndexPosition[     59194,       1489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"QuantilePlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/QuantilePlot"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"QuantilePlot\"\>", 
       2->"\<\"ListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PairwiseScatterPlot", "ObjectName",
 CellID->18540],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PairwiseScatterPlot", "[", 
       StyleBox["m", "TI"], 
       StyleBox["]", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]creates a matrix of scatter plots comparing the data \
in each column of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " against columns of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PairwiseScatterPlot"], "InlineFormula"],
 " returns a matrix of plots of the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["j", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " columns of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25508],

Cell[TextData[{
 Cell[BoxData["PairwiseScatterPlot"], "InlineFormula"],
 " ",
 "has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->28318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/DataLabels"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "labels for the columns of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRanges",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/DataRanges"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range limits on the data", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/DataSpacing"], "0", Cell[
    "space to place between subplots", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/DataTicks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "tick specifications for the columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotDirection",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Right",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Right"], ",", " ", "Down"}], "}"}], Cell[
    "direction in which scatter plots are generated", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "range limits on the subplots", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "styles for the subplots", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->27870],

Cell[TextData[{
 "With the default setting of ",
 Cell[BoxData[
  ButtonBox["PlotDirection",
   BaseStyle->"Link",
   ButtonData->"paclet:StatisticalPlots/ref/PlotDirection"]], 
  "InlineFormula"],
 ", the subplot located at the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], "th"]], "InlineFormula"],
 " row and ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["j", "TI"], "th"]], "InlineFormula"],
 " column takes ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates from column ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates from column ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->304688266]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635318086],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27801570],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->695023942],

Cell["Plot pairs of columns from trivariate data:", "ExampleText",
 CellID->74533663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataTicks", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26463],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 343},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->188558801]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->608],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataLabels",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->448092291],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->561257497],

Cell["Use matrix column numbers as labels:", "ExampleText",
 CellID->76349280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataLabels", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->558128806],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmzFv2kAUxw8fThgQYkHqgBoLGDIyMLDRqR2qzh1CK1BUyQg1rdKsKKO7
+SOgZqF2PgAjH4WPQt+d7byelVS+klYO+Vvy+d7z7/8HHsMzp+Pd9Mr/9Hl6
NTufem8up1/92fk37/WXS0rJihAVn86LF4LmOyGSUx0zOpNpfnZGoyQsomuV
rh90dqxGmal3+m4WiwepOBeP76Vuc/HZHtRPNVQ5zt6Zoh2KbtPrxwc/P8+O
tXcYhq/0ISI1yMFg0O/31TTWcRAE6Wu5v6noFgk3m42IaHBIEatArlYrz/MU
cmTSdDerqzMajZLKbbfbg6SrOqbK0Tfh+764SdXuPfmiboSQqlar5dzMfFG3
9XpNqeVymXMz80+p5qBBgwYN2oYe6pg70kWqPs3lry3cuCOZbpy3ceOOZLpx
vphbeWoOGjRo0KBB/0tayOSiDrUm4FipE5pXQOzU+qWP7tYp6EiU8R9V+rep
e6dKJOLxNelSBi+i/EVtnKzApfiu96MDHfPT3kmqHufyby3c+GnPdOO8jRs/
7ZlunC/mVp6agwYNGjRoG/qHjrkjuan6Opc/tXDjjmS6cd7GjTuS6cb5Ym7l
qTlo0KBBg7ahX+qYO9L3VH2Ty7sWbtyRTDezgxV1445kupkd7CnV/PHp4XA4
n8/DMBSRGmS32+10OhwvFot2u51X9Xq9er3ebDZFRIMjpYxVIBuNRqvVKu+n
LSONvRSgQYMGjWcK0KBBg1ZT7FwCDRp0WWm1R0D+p30Th6o6tH0WoEGDBg0a
NOjDpQMdYz8laNCgnzeNHXvPj55MJun/Tigl3quJctjpI/3zhZrO9p6Jyi9R
85pN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 366},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73395380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170222033],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->267051604],

Cell["Give explicit labels:", "ExampleText",
 CellID->97278650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10924719],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE+L2kAYxsdks2tBxIvQg2yDetijBw/e7Kk9lJ4LXVuUpZAg3ZbtXmWP
6S0fQboXSb6ARz+KH8XOvJnN64SlZNg/xO4zkDjvk9/7JBmFNw6jH2fXwbfv
s+vwYua/v5r9DMKLX/67H1dScmtC1AK5Xb4Wsr8TIttUC+WWdU/k5kh5miuv
VM+9I3fiCx35rDnhUkgtuZc831MVlerMrxRPCjmJcbSYS2c4Ylr842pWWnP0
6yS/o9Cqd0LXEMfxW2oiUTt3OBwOBgPVTSmOokhfk7eXJQ/JxM1mIxK5c2RG
qgJ3tVr5vq+QY5OWR/NRGI/HKenb7fa/pI8oliMn350gCMStzvbu0cu6SURm
1ev1gpupl3Vbr9dSWi6XBTdTP6QxBw0aNGjQNvSIYq5Ilzr7rKDfWLhxRTLd
WLdx44pkurFezq06Yw4aNGjQoEGr7++eXQapPFPgPHO2czcZ8cRZerqBJ0Rs
r3VvhoROnSVmszQH8Ml4TjqimJ/23ujsSUH/YOHGT3umG+s2bvy0Z7qxXs6t
OmMOGjRo0KBt6D8Uc0XydPZNQT+zcOOKZLqxbuPGFcl0Y72cW3XGHDRo0KBB
29CnFHNF+q2zbwu6Z+HGFcl0MytYWTeuSKabWcEOacwfnx6NRvP5PI5jkaid
2+v1ut0ux4vFotPpFLP6/X6j0Wi1WiKRO8d13VQFbrPZbLfb1b3bKtJYSwEa
NGjQeKYADRo0aNXFyiXQoEFXlc6+HFJTnNUqhP1VGvYrH2idxXG+dCI/6VOe
8yF3W533DDRo0KBBgwYN+jHoiGKsrQQNGvTLprF67+XR0+lU/2+Fmh/4RDMD
0mFHTf/IQ3XDB/dE7S+ZVHxr\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 366},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->297757410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataRanges",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->502684921],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->686247304],

Cell["Limit the range of data values:", "ExampleText",
 CellID->299346622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataRanges", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"DataTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145812446],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 368},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15369917]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataSpacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->157586901],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->356491898],

Cell["\<\
Include non\[Hyphen]zero spacing between plots:\
\>", "ExampleText",
 CellID->308616650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataSpacing", "\[Rule]", ".1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214327976],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2zFv2kAUwPFDTlqGdu+SyEs7e8neqWGpxNYVFFU1QxSUZEgm0omRuV0Q
LIyMjHwERkZGPgJj+u4uyisnJJ9Rqprob8nWnd/z7xnOw1k6f23f5t8v27ed
i3Z6ft3u5p2Lm/TL1bWcSmrG1HLZf3ww0n40xu9268jum+Vab+0xGQwGn91m
RvaQNBqN1WplQ+9dfL1eyykbGrt4v993VR/N8V+KhASaz+dmZA9WGQ6HqsjJ
LMs0PplM0jS1oTfbikRtc+T6rVYrVCRF43KjKHsoR64vIymPUJ7n5neBujs/
roqkyFX1ej2ySpgfV2U2m8kpgSOrhPmHNHooKCgoKCgo1VXOXF9nTZ0C9WOQ
f1+iis6a4qpofpkqOmuKq6L5cVWqNHooKCgoKCgoKCgoKCj7KQ+ur+92pwXq
tyD/vEQVfbeLq6L5Zarou11cFc2Pq1Kl0UNBQUFBQUGprvLL9XXWdFyg3gX5
n0pU0VlTXBXNL1NFZ01xVTQ/rkqVRg8FBQUFBQWlusqJ6+us6WeBuntWFldF
Z01xVcJZWVwVnTXFVQlnZYc0eq9IkQt7vZ4Z2UOSZVmoyFUa73a7OxTJ6rnt
KUue0s1mo4p05JQNjV3c37gN+dXvtrnv+vt/1/K/rdlsGr+N7SGZTqdP9/7O
xReLxVZc/sGt31bJMX+1CmvyWZOPgoKCgsK7CO8iKCgoKCgvrfBlEl8moaCg
oKCgoKCgoKCgoKCgoKCgHK7y4Pp8bzvke1sUFBQUlEKF7yf5fvL/K3KV8Ztf
l+5JG/Lr1pfLpX0MnuOetKGXXJNvan8AT1ETyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5965280]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DataTicks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11983493],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->7115329],

Cell["Use automatically generated ticks:", "ExampleText",
 CellID->62571008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataTicks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->682572672],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 364},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5455821]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->749381165],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->17714779],

Cell["Define explicit tick positions:", "ExampleText",
 CellID->45294536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"DataTicks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "6", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->471798351],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1PG0kUH/YDkKXjACEUHUhYAu7oznYROTRQXZClSDl8hXUNRtEJIxQR
JZFcoDtKl/wFEYkUxUkNEiUlpUuXlK4IpUvfmzfjnd1hvMwSECt4I3k9b9/v
/d7O21nPB499sfm+9s/rzffbrzazz99uvqltv3qX/WP3LZxyhxgbqsHnzRMG
9R5j4sPLNnxEdXBtgh/dvkWP5eDggFiQ39+NqN/5wVMyQ7vomQv8+hmOnlEf
Z9H3BUeWv4LLR65tXEr8rGvEX0RwBUOLTXi9zfmQH+XdFNMMWh4cHDBROOdf
vOLmcjnJ5gdIZ39/fxgtVldXT09P+76uXKMLSoDw6jOUx8fHwQmvljR8GeVs
Nnt+fo7NQxkEOMWrw+Q94r3dbne7XeW91WpFvIMSIIO9K3xZk+O9f9PYmreI
xh7mNhoNCE2tVmOfNGtP03+0YAMVoEdHRwewKb0N28nJCdzTw8PDAWxKH892
l1EkNKEJTWhCJ0GLUVKNLa816181/X8WbGpsMbMpvQ2bGlvMbEofz5aemBOa
0IQm9MNB81UCX9g5iaxG+VGu5/exJLer1+sbGxsOLDqZe3Z21sPCPms8KPud
TucUS7PZnJmZYSNX2La2tsCTA+MJc6vVqlxpmtnEuAOlWCxOTExINn6FTuJI
DIeuQRR72xHpkblBGNn99whCPzx0A7VqLjinWf+t6UsWbGouaGZTehs2NRc0
syl9PFt6Yk5oQhOa0I8dLfaV1dgyrFn/q+l/s2BTY4uZTelt2NTYYmZT+ni2
9MSc0IQmNKEfDlr8ubJfcI2eeK3O0dEshPCZJPsY1zIFOxviT9pc+QsyqXGu
oXk61PTI6F9eXgY7H7Ozs3KvIt5/eC+kUqlE/KuR0exf6YV/GPWCvZKxsTEr
/yKSc8inxk6zP6X37/ie4S6L7D/ujfpPep6GDJ6t1+twdmVlhX3lB9fzvIWF
BV5togy3bHp6Wrfa3d2NWEGZn5+PWE1NTaW11beE9hSaaXlCN8rpGMDH/J2d
HTgvHqFqtSp6b4Icjw94Eh7+4Cn0gh9D4WFvbw9+bcSPRKvVkh7s8z7Qw0h4
h1XlhfnWkRTP1d3hTXcq5X2M0IR+lOg51NrPdMwjf5TNft5iw/ajs5L0xZzQ
hCb0fc8nTbOaG+Vp+cAXXvREZnywvgtWwrlcjj1Fhqx17tYeygdB7nx/JRTO
8HYMbUiYzxXThtg4Bm2zn+1xdLJ76thdT3p6GKEJTWhCE5rQhL5tdNJdqdj5
mdj/F9tp7XabfdEYRBZieGefxc7AcMYX7CJWKpUBjPpevfPDbblVm6QxTk/v
IDShCX0tWuylUZYpoQlN6MeN/ohaynrU0cIXzH17WOS7IAbLRY29pOnLmmzz
Joq1tTXxD0fSG7BLa/EmClAChFfNb6JQeOF9aWmp0+nYen987wDBfi7WL8zH
rKTJyclCocCreZQ9zxMrF5ZDGZQA4dVnKPu+v7i4yKslDV9GOZPJLC8v86qH
MiyA4KboV9HtdsWKi/mYm3V0dCTl/DVyEeXj42MplzR9WZMFvwgMdy1WO7y6
bajxoK73Qv+HB98/Ka0W95cY7CsZUSFE5t5th2Qrygltwpr1BLb9qP0pv/v5
XSqKpriLGhv6H/lz1Cg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 368},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->739216928]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotDirection",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->375558641],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->83330709],

Cell[TextData[{
 "Plot with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " indices increasing toward the right and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " indices increasing upward:"
}], "ExampleText",
 CellID->159827577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"PlotDirection", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Right", ",", "Up"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42151277],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9qAkEQxlc3JhYiNkIKSQ61sLSwsDNVUoTUaVJ4SMiJ5A/GViwv3T2C
JI2cL2Dpo/goZnY9mOyR4pYE2ZhvYZeZ737ziSssLKPe+JPg/tGfDAe+dzX2
X4Lh4NW7fB6TJHNC5AKaD6eC4q0Qu6nGkOYutItO1CqjKLrQQ8RqkZ1Op91u
q3Cp8zAM9atsReFLFT2iwvV6LWJa8lSxVIlcLBae5ynk2KTpqQpjWvK9Xm+p
9c1mc5D0kc5p5+gjCoJAfCTVhW/0rG6EUFWxWEy5mXpWt9VqRdJ8Pk+5mfpf
2nPQoEG7R5/pnM+8t6T6I6UXLNz4zDPdWLdx4zPPdGM9m5s7ew4aNGj36K7O
+cx7SqpbKX1m4cZnnunGuo0bn3mmG+vZ3NzZc9CgQYMGDRo0aNCgQYMGrcJQ
53zzPE+q71L6tYUb3zxNN9Zt3Pjmabqxns3NnT0HDRq0e/S7zs2OhKqepfSW
hZtndCTYjXUbN7MjwW6sZ3NzZ89/n+52u6PRKIoiEatFNhqNer3O+XQ6rdVq
6apms1kqlSqViohpyUsplyqR5XK5Wq26+25dpPHtB9CgQYMGvW8aHVbQoEGD
Bg0aNOhDpEOdo2sBGjRo0KD3R6NLBBo0aNCg3abxy8v/R/f7fbEbJIlbFSiH
rR7JPziocPjjSOQ+ARau1Bw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->292218113]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1758],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->255474996],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[2]:=",
 CellID->340306335],

Cell["Visualize covariance matrix for multivariate data:", "ExampleText",
 CellID->119109381],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", "2"}], "/", "3"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "3", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], "/", "3"}], ",", "2", ",", "4"}], "}"}]}], 
        "}"}]}], "]"}], ",", "100"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->841690342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->79470742],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->534591929]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->690],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->416348097],

Cell["Overlap pairwise plots:", "ExampleText",
 CellID->89404635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PairwiseScatterPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}], ",", "0.1"}], "}"}]}], "]"}], ",", 
   RowBox[{"DataSpacing", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztne+PlcUVxy+7e+/dZVldlpWFldUFBSkgCKxSsAoUdDX8MiuKWGtcEV1U
sNmKqNUAoUrU1mCMiZKmvCip2rQxGhPS1L6o1jc2krQxTSRN/FO288zcO2ee
zzOXe+aiRVM3uXC/d+Y558w8M+c5c86ZebaNPzmxd//4k/v2jA+PTo7/bGLf
np8P3/rEpPmpfVqpNG3CfB6ZUzLfp0ol98n+9pmP+5r2rZr92z5tmiFt/zKC
u7Iv2W+W8lSpHNQ0JaZg1qxZpSnzz93Zl/ZKpeLEKFXyNU1p9jUjcrf9bdu2
bd/X/L5moeYMi/v7+81P1Wq1dMLi48ePGzwxMeFGYNnhoaEh8++SJUtKbdmv
He5XV3EU190O3KOWpt3OAXNNbQ68EJOofXh42ODOzs4czv7aso+Vz/9mqnWA
yo3AbaDahvLNKNe3p1TO6tf/MlqHQbsj1qKeM2fObNiw4dSpUwb5uua7+31s
bKy3t3fPnj1O0m7z6/LlyxcvXowLhGoFXFdFW+y5FnpkM8oTeiC7yqkqe3fC
u/scuHSAS1es3yse+4qVKB1p7VLQrUZbK/V3qFpnpSm7vm9vzwqyfw+CVgW8
eqM9yTYL5vhYBPozUa6T/VIr+8DAgB+b2czeD9rtoN2P8gGLR0dHa9d3Q/Yy
6l8BejNR/2bUv0TfloxKbaplo2w/OLWDUz/KXUs6OjpqvTEL5Vfg+jGU6yTt
rY+Y+fPnl8vlWisfB+1BYCfbsWPHanN+VnSESK+tBP4h6utk7ctrUUPoQdC9
F33Qh/J5KL9dz7fi76a7JYbcA9E7ItzWNhl703H9PNTXSRf2ffbcdBrNjP2a
RtsVnUHChTNgPup3Aveh/nTQuwv1e1WtuMzeW0PFG6C7wedq8JmP8s7ovZf6
D6JcJ9dsK5cZ6V1dXa5B94DubcCdwHPRH9dE5wa1cTO57Awsu9b4AVnaDtqH
CjNmEXphcwI3GWPu2u2gdah+D908Mf8uQtt03OYG3JYtW1bT5FtBi/24AZia
nzppB3C/SrbLbRu9VjYXbgad5eiVpU3mD/EO4BS5zDhta2tzF9JCXI7+WNpk
vhDvANbJNS+4lzt37qz1wY9B6z7ga9Fn1KzrVbyp2f4Z1deCE6gWRudaSHg0
qnUF06bi0/wq1J+rkm3YYrEZ1qKFR4FpTd0BnMC17KyBkZGRmsRr0KLr0KLt
KOdzqRf1b4rq1WayLUCLHgV+BHi3nmphVK+AxDdA4utRvgLlOt5XF3Q6Nc4B
4CXgy7XmsJ5vWWxad+21aMMB4CWQhdbEbOAB1NfJttD2Sfjk+QfkoHUwG3gA
9XV8+Xz7N/Bs4HUqqovRJ9QFLwMf0lMtWAy0ol4GJm+u9RYntIg2qqy6qf2o
TakrroKUXC2zVToplxRG0X2g8yTkoE9iPsp1fJdGtQntxptBez3KqW+3qnhf
ixbMBT4C/KKeaqFFnGNHmrToUuBVKt5Oq86cObPkvB/nrCyOSk9PT60d1g9U
KbqlUng4X0W2aj4XzK1KpVJrj+NR9A0l8Kj4i7yoPeiV14BXo1cvAb5exZ3e
uB7g14CfS6Da2NP0GrCO6oidt6H3d1tMY04PvZb+u/+yNoFX6MndFtOg0z02
yH/3XxJ4Vbwn1U8k2pK3oNfo67aaY3rov/Xf/RedRGvQVtqPHBVHE6g2tgQ5
KnRU1xZGxefol27gauGKFQmcwjHxOfqhG7hauCKFU+hb/xx9w1VvtXCFjtMa
9A3HHLVOyp3+n4yfrM0LFixw4p1AjR9A+mXAi1R87bwqWFQ3gdazaNMQymeg
PIU3PTI3gdazaPcQymegXMd7VWweFZ72N4L2nbiK8Ztv3XPpvCNoAK3ZCHyF
iu8mSPsH4I3ACVQjlsPbaAPXq7Si6dnVcb8VMn8JTJt5aQJVkeVLYEYLdVTp
Z3LWr0SPjqCc8QT61gcSuNLmFq8NbW56CHcBp3Cl/0RiOLTG6f/bFZ0Bzbhu
baJp3wXW3bet6IFlwO+2NMa2RvXYErR7JyQeQzk9Gn0q3vE1v6xi6Llj9JzR
jRSuXO3LuuYo2sao9oPRMZPiDZDVvOCXgXX+jTH0iPXF5Kw53dPN0sn51xiD
3puvYTqCUehLEziF/gbGiPfWa3jrjVFiHac70aP7gZ8H1lG9Gq3m8+QA8CsJ
VKWFK4Dp3UyhimdfYa7vhsTMjPgFynU5J/dAYkY2XwVOoJqzUQYhHS2wZ6Ka
iavxZnwp/SDwGeAFKqrDkM36ziM2DH1Ij+C6bShP4S4yY0UXifIxssJMBF1f
DkNav77zGoFRPOYUUO/r+P4UVGiL/7alkfEA+uCsnWMOr1mzpvbrlQm0pF2O
lsMuRSD7NYFW02jNyaDW5ORkznuWmv8zD1dtKoynZlHiwyhP4StXbSqMp2ZR
4MMoT+HbeDwxvntCRdV8lFmjTguI3V5Fb84Efg84Xl/HVez2KvqSeXDvAcfr
67iK3c7MQWawvQccr6/KyShEZAQ/Dbw/gar0ADNKngZOoSot3B6d/7znzHlj
HtNlKt6PN7nHfwdOoFpoQRkS/zXDcS+3r6TjRxvr0wxXoz7t0pwEiiKroxj1
SSsp8snP+/kJ8OUqqly9cUTCc2uq3IYrDuGKFL6cCRE/rtfkt+GKQ7gihS9z
EAQzu+0NFVXzUWruuMXNuyqa/QzKp7c0S2nD9kZnrWh22rTM3EzhygwXambR
7GdQTn+cjuss9BAt1SeAJxKo0v4V/ARwClVp4Q2QzfrtI6sC6u51uO6ie5UC
2SzVgi6nb9Y+latRXV7rpWZ8n4e0f5lqrMNTKIqMjmJch+soMmeTsZOTwLoY
Aa093kfLJafDR6JzRK5I4cvxI33i+IY6fCQ6i1JjIrT46N0ZAT6pomo+Sh0e
z2vjk1d0OPOX6BPWWaTXo+/oJ3JcRYczs4mjIoUrYyh86ooOpy+TY0LHlZkw
3NGzF3hPAlXpgYPAe4FTqDLOILLZp2BEh3Ps06eqy2fiepYZXM8Ap1DFerag
w2mB2bi05Bj5Lzrv6q8g6fu2ajGXJIWayPZ+/i74LzpqC3BvHgWmba7LbKWv
hfrUcsnpbXoNGU9N4UtNIH3l+IZ6m/7CTbgiha9cdRiY3sFTKqrmo9TbtASp
t/8ErPMFXY6r6MFkfh7X2XehfgpXuYoeKGbskctdqK/jylw8Zt881UDXMWbI
nWH3J3CXNhwH5m64FKoi23Hge4F1VC9DC7k/gvkTBxOoMl+ocf5EClXkm0Xu
IjNy3fNS7Byd1/w3kPH3FovdkkJFZHFUxA7RUeHq+xVg5kv8UkXVZhnl1jKI
3uV0+gzwYM5SCs9wtSN943iG+pw5WEPozQSeBS+3YJafVlE1H6U+pzZiFqyL
BoQR8TmocQxYN2qoh5gRi+iH+WkOahwDTuEr/cnYn49++Oj5HNQ4BpxyhoD0
0pvA3FmoswY4Bt8E5r7AFKqrV682Pw0ODjqqhd1rzO4cRb+0fnpGqMlOAjP7
8/WWRsEMaLqTwMwmfr2le66fhfqaHEc864TlOn3hrhL76gR6lX5ynE1ifvpd
Ah+xqKjtGPloq89Gr3VT+NB7IZj3V0dVf5e4KjkMzDXIqQSq0jujoELvxnDh
Lr3a0pzkmmMUfOjfGC7ctdayVTiWbwef3YFekhX1LbjqQs58EYnfBr4FeGdL
49JloIr1x6yxVUELRfNy5bgJV+nWIW7FKpqVeWQjKH8J5SlcRLPG/YxS/hLK
dVz0M1Nfk1E9Rp0Yw9NFuRizY1SJETodVVpxldhMCfBy1A/PapCZ9HoC78ZP
ZMbrU6g2fgIzXq+jyhwbZmjdB6zLOWEGDSMD7CHLJaeXn8cVOo8aM2gYGWAf
Or6hXma852JmhtJf/SEw43MJJ0QVcpwb+6/2F+4Ns/ZS+Eof8CQR7u5iJGJ/
fUa6e1W7imcg/QhUE86nCXjRA8X4xIHCuGG+QgrfxllG9IXrqJqPUqPHd24I
PgL8YgLVxvruCLCOKr0qPE2L+o+Z7PH94TqfBDMbXgFmi1OowqMSYO410VH9
zu85LNg6GI+5bO3HUEO3d4L5SPR4PhbVkc2oUpMyy7iRB5TnujHSnMKd3jc+
c/Ekz+n160Ah4Vy3wu4W4cO9Fnz2n6jPy5xep8blbsmE85wCXv2gGt05n9Pr
D0Up6PgK3T8DPwSso2o+Sr3+DZ59EvQFzw9hboCOKmMa1Irc18RVxvr6+Mnp
9W9d5CPAG4F1VOkhaXZW1mQCVWnhoujdQA/ltEZruzcZlV0EPhwFRwszs7X9
m/SYvAHc2v5M7mP+DPga4JTzAl0LL9bphLTS6ek6VL8qp70Xohepj3SnjtGi
44m59K8/XRgjF3ASW0D3E+A7gHVUzUepvb/LuaaMwTPOzRXGncGoE+39sIo3
n+5PATM7IYUqsg8KOxoE66jq7z5X/bQOGeN3u1vDeGRrpyjQL7ASmM/C4v7d
1s5ZoF+APu4FKOfT08oROd+Hp13ydDSddN/g6Zfn8YV8Fp0V9G7Rdzes4s11
AG0gahc3gyUSdiPqp3CVq2gjUfs4rhIX4y7cFK5fdxaOfi7ra3LU8xnA3EBa
zc4HJ3GT1qLlfEbwnE+OFcdVIiIpXKXX+Qx5FJhjxXGVCImOK8+g/wj4Ak4v
CnrkI2DmR+uocjRwNczMZWvh5fwizLVN4UubWvj8GuU25pezPRkj0p3VyRFh
+ebyjoQi42FWhsi58vEzHoSO7lRJ22+53RlC8V9TUxGLmT4GPlcTTtEMqHwR
vZ+0sL8dEYUPgddFtUaqXfAh8LqoVtDloDeOb/F0h4uZL09/IqMF3A9Oz8jy
+syAvzHFrycy85ySt1C+sqku0J2ZR38iTzJ5C+Ur67rPr/oYzdHxZdyrCj5n
g9kuNhk91PRgp/AWic8BM89Ft6OJ2ts9R8fHxw3euHFj6QOULwxaKLkVMxqM
It35qzyJmhbEB8DOUyIWBXVLCtfGFsQHwI6rWBTUPTqu5vO124VcxXA/D7NT
aSfaKEBudbg+gS/93o2zU2kpDuW1gfkphS8944KZnUpbcaiuDXy2qo4vMxS+
slU99l8SzpwNesNR89h/0VGjT5bRaUb4Po6NmUo4r7u7u0/V364l9a5LkIax
cmpAKf84OpJc/ew1GzzFnF6+FKmkT5hNQL38cWycVbyv1b//g3lDOmkYwfsq
r0P9F93912sLPsPOAfNppXuO8OlEKtxvHM+LEw9CClfGgoUqT2mN58mJB0HH
dQOo8H0ZzJtNaYv00H+AL+SMdukBvhWiC/hT1GcOs3srpCt3E8C/FZJ5FMl3
j2+O4BsAP0V95j2Hp7RkY8i/DzKoo5MsPNF6cHDQMONbZP7WRN9aip3h26ym
go0xCVIEsp8Fbs2GZcbBWWCuIHRUb0V/8HlDz8lpYOb0ppxV2zjjhJ6V08CO
q1iSrZ2Qy+cGd56fBnZcxZLUceW7Zb4ApgWQ4kOQHvkCmE/y1jwTC3F3/4hy
yyVbVfT19bk7kdVK8a5Ju5mh/U5MN8l7xcxfa1485mi/E9M02XvC3CF6RiGl
8JG++ajJ6NJRZR42T7DkaT+60xyZh80YBX3FlkvFW/z+qMIrVdwWgjrf50er
kD5jninqNWEtLu2sTOdLzIqGEqQSri7bVFbQzHqzPqmyK3d/Wa2UHpAWcQc4
Twi1vtiqL58K92aGHjdpvdjY81QS8RwAZlzSG2xHd83KnZyc9P6YlFPcG+cM
HEa5jQN2wR8zFXqKWzsBrSMYx0Z4X2BXDNXQvyUtT+GEGSWrAl/gOIUeLWm1
jhNzhbjjh76tSdSPn/WXkj0hrdwC2jwfxa7oO3y5KeBonZ3Al7qTWk/4MsYy
Dsyz8K2cZX997fZYWcvuPbHUjbpcJJGIkW5GY8aBx/Ljx2kA80SyMmWDy1dN
kYcxVnpEMVOC+uPANpeqGr7RcMuWLbmYny4XA+OysIIRfD/q27N2cj7p1vJG
o+cInid+z9y08WCMmz4wP3GM604wYm4K3wZJm5hjnPviOMbHG4/xDjPG/YW6
/Su8W4wHNMsd4jOfz6OHzzf+2+UtZTppKR33cHJFxjHC2cD8TI4Zm2Ne8e+a
LdVXoynSMsZGS5nWROMRS/8n19ZhxLm+/g7fj63bQxp/k2Pj8XoNyjlCON45
ng8G879SqfixIfNuhkpuykWfyHrwZXkcM+rBmcB2yxqL/UD61tuSsw1RFvCy
bzcqe1xb1GSNb21fMNvGk4tYzntGz5Frq6zp2Dek59oe5g7AR9jhfILuL6WN
vL+CaV+x3O1Kk/UkzxxmfdcGaLZamWuDwWZAGwm7urou3tkL39f8/6lp/iv9
pFS7ytbdd8HfStP+C9e+WFA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 359},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628500258]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuantilePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/QuantilePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21543]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11600],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->26969]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PairwiseScatterPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 35.0217714}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "PairwiseScatterPlot[m] creates a matrix of scatter plots comparing the \
data in each column of m against columns of m.", "synonyms" -> {}, "title" -> 
    "PairwiseScatterPlot", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/PairwiseScatterPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7269, 247, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->635318086]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 59051, 1482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1344, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1967, 62, 57, 1, 70, "ObjectName",
 CellID->18540],
Cell[2027, 65, 631, 20, 70, "Usage",
 CellID->23245]
}, Open  ]],
Cell[CellGroupData[{
Cell[2695, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3173, 107, 434, 17, 70, "Notes",
 CellID->25508],
Cell[3610, 126, 301, 10, 70, "Notes",
 CellID->28318],
Cell[3914, 138, 2417, 67, 70, "3ColumnTableMod",
 CellID->27870],
Cell[6334, 207, 898, 35, 70, "Notes",
 CellID->304688266]
}, Closed]],
Cell[CellGroupData[{
Cell[7269, 247, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->635318086],
Cell[CellGroupData[{
Cell[7654, 261, 147, 5, 70, "ExampleSection",
 CellID->27801570],
Cell[7804, 268, 141, 4, 70, "Input",
 CellID->695023942],
Cell[7948, 274, 85, 1, 70, "ExampleText",
 CellID->74533663],
Cell[CellGroupData[{
Cell[8058, 279, 465, 14, 28, "Input",
 CellID->26463],
Cell[8526, 295, 9859, 166, 364, "Output",
 Evaluatable->False,
 CellID->188558801]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18434, 467, 216, 7, 70, "ExampleSection",
 CellID->608],
Cell[CellGroupData[{
Cell[18675, 478, 231, 7, 70, "ExampleSubsection",
 CellID->448092291],
Cell[18909, 487, 141, 4, 70, "Input",
 CellID->561257497],
Cell[19053, 493, 78, 1, 70, "ExampleText",
 CellID->76349280],
Cell[CellGroupData[{
Cell[19156, 498, 531, 17, 70, "Input",
 CellID->558128806],
Cell[19690, 517, 1070, 22, 70, "Output",
 Evaluatable->False,
 CellID->73395380]
}, Open  ]],
Cell[20775, 542, 125, 3, 70, "ExampleDelimiter",
 CellID->170222033],
Cell[20903, 547, 141, 4, 70, "Input",
 CellID->267051604],
Cell[21047, 553, 63, 1, 70, "ExampleText",
 CellID->97278650],
Cell[CellGroupData[{
Cell[21135, 558, 589, 19, 70, "Input",
 CellID->10924719],
Cell[21727, 579, 1091, 22, 70, "Output",
 Evaluatable->False,
 CellID->297757410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22867, 607, 231, 7, 70, "ExampleSubsection",
 CellID->502684921],
Cell[23101, 616, 141, 4, 70, "Input",
 CellID->686247304],
Cell[23245, 622, 74, 1, 70, "ExampleText",
 CellID->299346622],
Cell[CellGroupData[{
Cell[23344, 627, 741, 24, 70, "Input",
 CellID->145812446],
Cell[24088, 653, 2269, 41, 70, "Output",
 Evaluatable->False,
 CellID->15369917]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26406, 700, 232, 7, 70, "ExampleSubsection",
 CellID->157586901],
Cell[26641, 709, 141, 4, 70, "Input",
 CellID->356491898],
Cell[26785, 715, 98, 3, 70, "ExampleText",
 CellID->308616650],
Cell[CellGroupData[{
Cell[26908, 722, 525, 17, 70, "Input",
 CellID->214327976],
Cell[27436, 741, 1044, 21, 70, "Output",
 Evaluatable->False,
 CellID->5965280]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28529, 768, 229, 7, 70, "ExampleSubsection",
 CellID->11983493],
Cell[28761, 777, 139, 4, 70, "Input",
 CellID->7115329],
Cell[28903, 783, 76, 1, 70, "ExampleText",
 CellID->62571008],
Cell[CellGroupData[{
Cell[29004, 788, 530, 17, 70, "Input",
 CellID->682572672],
Cell[29537, 807, 2455, 44, 70, "Output",
 Evaluatable->False,
 CellID->5455821]
}, Open  ]],
Cell[32007, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->749381165],
Cell[32135, 859, 140, 4, 70, "Input",
 CellID->17714779],
Cell[32278, 865, 73, 1, 70, "ExampleText",
 CellID->45294536],
Cell[CellGroupData[{
Cell[32376, 870, 694, 23, 70, "Input",
 CellID->471798351],
Cell[33073, 895, 1880, 35, 70, "Output",
 Evaluatable->False,
 CellID->739216928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35002, 936, 234, 7, 70, "ExampleSubsection",
 CellID->375558641],
Cell[35239, 945, 140, 4, 70, "Input",
 CellID->83330709],
Cell[35382, 951, 260, 9, 70, "ExampleText",
 CellID->159827577],
Cell[CellGroupData[{
Cell[35667, 964, 581, 19, 70, "Input",
 CellID->42151277],
Cell[36251, 985, 908, 19, 70, "Output",
 Evaluatable->False,
 CellID->292218113]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37220, 1011, 222, 7, 70, "ExampleSection",
 CellID->1758],
Cell[37445, 1020, 141, 4, 70, "Input",
 CellID->255474996],
Cell[37589, 1026, 147, 4, 70, "Input",
 CellID->340306335],
Cell[37739, 1032, 93, 1, 70, "ExampleText",
 CellID->119109381],
Cell[37835, 1035, 798, 25, 70, "Input",
 CellID->841690342],
Cell[CellGroupData[{
Cell[38658, 1064, 117, 3, 70, "Input",
 CellID->79470742],
Cell[38778, 1069, 10050, 169, 70, "Output",
 Evaluatable->False,
 CellID->534591929]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48877, 1244, 222, 7, 70, "ExampleSection",
 CellID->690],
Cell[49102, 1253, 141, 4, 70, "Input",
 CellID->416348097],
Cell[49246, 1259, 65, 1, 70, "ExampleText",
 CellID->89404635],
Cell[CellGroupData[{
Cell[49336, 1264, 558, 18, 70, "Input",
 CellID->7949],
Cell[49897, 1284, 6642, 113, 70, "Output",
 Evaluatable->False,
 CellID->628500258]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56600, 1404, 308, 9, 70, "SeeAlsoSection",
 CellID->28],
Cell[56911, 1415, 476, 17, 70, "SeeAlso",
 CellID->21543]
}, Open  ]],
Cell[CellGroupData[{
Cell[57424, 1437, 314, 9, 70, "TutorialsSection",
 CellID->11600],
Cell[57741, 1448, 172, 4, 70, "Tutorials",
 CellID->26969]
}, Open  ]],
Cell[57928, 1455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

