(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29795,        969]
NotebookOptionsPosition[     24188,        773]
NotebookOutlinePosition[     25561,        811]
CellTagsIndexPosition[     25476,        806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["STATISTICAL PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statistical Plots Package" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/tutorial/StatisticalPlots"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Statistical Plots Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BoxWhiskerPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/BoxWhiskerPlot"], "ParetoPlot" :> 
          Documentation`HelpLookup[
           "paclet:StatisticalPlots/ref/ParetoPlot"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"BoxWhiskerPlot\"\>", 
       2->"\<\"ParetoPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["StemLeafPlot", "ObjectName",
 CellID->28978],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StemLeafPlot", "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a stem-and-leaf plot for the real-valued \
vector ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"StemLeafPlot", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["data", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a side-by-side stem-and-leaf plot for the \
vectors ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " displays the distribution of real\[Hyphen]valued number as stems and \
leaves in a tabular form. "
}], "Notes",
 CellID->617304553],

Cell["\<\
Stems are multipliers of a base unit, and leaves are remainders rounded to a \
given number of digits.\
\>", "Notes",
 CellID->553467341],

Cell[TextData[{
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ", with the following additions:"
}], "Notes",
 CellID->4015],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColumnLabels",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/ColumnLabels"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "labels for the columns of the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludeEmptyStems",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/IncludeEmptyStems"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to display stems without leaves", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludeStemCounts",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/IncludeStemCounts"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include a column of leaf counts", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludeStemUnits",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/IncludeStemUnits"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether stem units should be included", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Leaves",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/Leaves"], "\"\<Digits\>\"", 
    Cell["how leaves are represented", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StemExponent",
     BaseStyle->"Link",
     ButtonData->"paclet:StatisticalPlots/ref/StemExponent"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "stem units given as an integer power of 10", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->16626]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85887296],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->539086200],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->109099088],

Cell[TextData[{
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " of one data set:"
}], "ExampleText",
 CellID->11270735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{"{", 
   RowBox[{
   "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
    "2.9"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85151077],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWN1LwzAQz5q02xRBEHTza4IKgptv/gv65Jtv4sMQQR9E0f3/MWmS9nK9
tGmrY4W1zfW+cvndJbeH5ert9WO5en9Znt1/L7/e3l9+zu4+vxWJDxhjT+r3
PGHqXaq3/PckpXrCO+Pmoe+JeqbqhVuyYOV3faXqN1bDBNE5s4LMXfpdcwur
LbHahJXeVk/9feD5wCxnLirdVRjjVrG6MsBVUseAy82H1icQZ65/iLigbQG/
ab07SIOZSUpaSxGvCHtfkW3hPxgP0Xi3pbcpsvw/Xjp07JHeJfYrqaXWgxhv
C2xAvDT4S1vmsg4RML9cZLkss4Izn2cEfEuKILqkSoC0ANpEsx+isAH0QL4b
ND4MrkqCfF4gzhm0wKo1J/5+jjTf1lCnNi4Y+y7q1zkXnlWGxljaSO2re0bo
DnNXcTKKkj2QXrWJlpsAary1blJTu76YO7P0Reu1Wy9Vx5iz6n6RWfq8xSrS
NTQOa/8lO7HrUD+/Phb6xyZuDTYBLTRVRyAN5ICrzu4cpZ+z3nGj91h8tjgu
ogupOMr52Ksy1N4Mx0cS1wv9ij0P6PVOT3pwIl0dqas2LpZwh6tGwOhqQjMe
k/MN6I5bNWwh7txiLNRlgzs3QzSdyk3Jg3bZgU9AlzIGVW3y4SJKI4mGjrow
avv4lY8r2RIXpWruXfWILs4P44PGqd5Ztoh4clZ2j2a2bRDzyOzpas1Ibdv/
hk6XsEalRPzcd9cJjz3rYTzHdb4kvj0s4N6GrnfYWlyVzK336n3X5T9pp1Mf
HFNRIC7o1U2kXw8NKv6i8+1W8cJe9qMahHTphZt2WHjWKnSUPTPzoylKXxr7
YXyGwtbnxVrhfvgYcbqaYvoi+7/b4BdkzhLH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31784027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->708025970],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->355903335],

Cell[TextData[{
 "Side\[Hyphen]by\[Hyphen]side ",
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " of two data sets:"
}], "ExampleText",
 CellID->38491534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2.3", ",", "2.8", ",", "1.4", ",", "3.6"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->769612083],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWV9v1DAMz6Xp3Q2E2A4QCNhtgt3gAZBAfAZ44iPwcJqQtgcEGvsY+84h
bpPGdZ1/hStHpWsa17F/duwk9X3Z3lx++769ubrYnn6+3v68vLr4dfrpx7Uh
VTMhxK35fX0izLM2T83vVmvT4ruo2gbu0rS1eagsWQn/Hq7a/A5MVxJ6JexA
4S54Bm5lpUkrTdnRd00L7z/0MAjL2QzV7uqUVVawueaIy1MPEJezh5enCGcj
f0G4sG6F34Hce0RCa0nNaqsJrwqjH4wtwI/6C9I/LERbE827Qemi4wGLTtq3
rJQoghy0XWzgeEng5TVXOhYROL+cZyvts6ISfZ4lwiY7J7qkkmi0QtJUGofq
dCA5mO8d6T8NzookmN8SzhPL81HT1ab0/p5IfsVhzuQ6s/5akrcr688VO+qc
UOloGrtHo6TcN7f5aAwwehiXFFmerGal8KvdaDnYD+PR5EnZ6Dbe7pC3K0vn
R/3N2Pq/ucB/lRjun4eW/pDQ55a+0S6vhtE3Lkb5HemsQE8qH/+thpCnQYZk
PA2yVKGns/Ch/nmB7LxZnJP+Jmp7KMoWlt56bl9zZ3+yFeamDsyGOy9Au9bT
ZC1/Jjxu2tcMxth5lcZGY3tvl6KnmWdZemhuUMty9YTmhO7ntA8xLgdzs+FQ
FGR4CeqYnl3NPuhVTLSl9pu+l/Y1P6fnWmv/zc6dcEMrw9KOe9lIOS6Yx9g5
TYfyCPVfRDTSWOX2ypguiMd5wir6TVlqT2yPB40Q3XStod/kKR3N+F4We/kx
7KVrHMblrVgTLv7bt9RvvK4T7eM3dEKAVfIRY7kUuzghQOlsf/M9j4tW6HCd
wNUN6Awr4Wt1dBaamFd+7tK1QhrxuP5RgqRZg9p7Lx9ovQbX1TqmQe2Qq0Kl
Ixuwh+uJefVJNlMns2i2Uy+mViG+EpdXGZ3Kb6Bn1vcUiUocvXwkSN2v8dEs
CvshXHNN+XYcMpRVyXU+LPHPqJxl7qRXhqrMW9NZyMeSO8ni/0egRdVeRAUi
d17msienvhzzzjhkvJVvEni5KvTjBL62ltBHQ+vPMIbWqJ8zWKDbVj/sf2Gz
30ewIAI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{140, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->931996939]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29022],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ColumnLabels",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->502684921],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->573185034],

Cell[TextData[{
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " with stem and leaf columns labeled with \"S\" and \"L\":"
}], "ExampleText",
 CellID->755057619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"ColumnLabels", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<S\>\"", ",", "\"\<L\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41451835],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNGE1LwzA0a9LOORTBi3hxZ0Fx6kVB2DwoCP6C4aEMYTuIMvf/Y5Im7evL
a5uum6zQJe/lfeV9Jd17ul58fqXr5Twdva7Sn8Vy/jt6+V4pFO8xxmbq/Thj
ai7VzLwzKdUIfxnPBv0bqTFWE27RghXr+onVO1BghPCcWUbmHj3X1MJKi6w0
YbmHatTrvZINzFIaVumeXBm3gtWTAKoCOwBUbj+0PIEojfw+ooK6BVzTco+Q
hGwnMaktRrSi2nqPt4X9AO4j+KSltTHSvBsrXXacktZFdpWUUmtBiLV5bsB8
abCX1sxlXUbA+nKe5bKoCs7KNAfAtih3oiuqCHALIE002yFyHUAOpLtG8Hll
VCJk8xWivIAamN9zwn+PkeS3GqzLJpz7zusTmec8WE0QjLknpSiagBA66rkk
kVtheg1X0XvU5CCID/fLXXK5no6pE4t/bh3J/8W6KsSnR2Lx09axpPtqWP7t
itd1h/pddtGwLQ+FxWMfMofG4psRVReuf7ublh7vt+RF+izGkR3nvoZY7HMD
l/oPdYZD+EbiTqKn2AcVcku3LA3cmkWsA/ch51F4EvoeyGQ1ZTiGyf1WyG4T
OwyH3XIyPXUV4m7ZMLPu5L7UxmYVg+9NjzIkx9pUx0OQRDI3NpSFc7iLXQb2
aifMS34lPnXwLubKbHB3xkPCn5wV35zZbttkzqVCjFtzbS9jTeSISizfOb3v
26a+UIpH2NnfiQ/A0zxiVR3Gp4beGIZxeF8jTbVW2IW/Pqj7vgaze6f9l6P3
Bzug1ec=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326133065]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeEmptyStems",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->306150385],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->257316178],

Cell[TextData[{
 Cell[BoxData["StemLeafPlot"], "InlineFormula"],
 " including stems which have no leaves:"
}], "ExampleText",
 CellID->617151523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "7.1", ",", "1.6", ",", "2.6", ",", "2.9"}], 
    "}"}], ",", 
   RowBox[{"IncludeEmptyStems", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119666391],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWU1P3DAQ9TrOwhZVqoREl5YWpIJUiY8bf6E99dYbpxWqBIeqFfAv+qNd
O7aTycvYsXe7NETKJnbGMy8zbxx79tvq6e7Hz9XT/e3q5OvD6vfd/e3jyZdf
D6armgkhbsz5ZynMvTZ3zXmjtbnSX1G5i/2V5lqbm8p3K9E9t0dtzoVpSuiv
hB8owmHvrbTy2qTXpvzoPXO1z2c9DMJLNkN1OFpjlVdsjjmR6noXRCq8D69P
gWSjfwekqG1Fn1m9r0GDe5OatVaDrIqjH4wtwE/aO9B+U4i2BsvbQRnYsc+i
k/4pqyWJIAdtyw3KlxG8vOVKpxhB8yt4ttJdVlSiL7NLsMnWiSGpJBmtiDY1
jkO1NogeKncF7XfRqEjAfAmSx9SCGM45pb+fQP91oncJvbvQDjE4z5LGPHKj
Dkek/v8ojN08a9SB5vid55MD71eUtpYtFy4TMZtC71vtsgq/IdcFntm+rEoj
JL2vom9Je3ldS+8LHscUorXtGI7lT4lUGlVeRPKl1AuM26H3EM4sJV620Z1H
dZTEvvF1t96LytFvR1xbnpT1gHyBkZtmxi29N3lU+XwqYUzcC1OIE9+b+maH
Faa9hhXncYFn+L0Fv0/A/dFR69XUnNe0e3nK7S9o+73GjLS3iDyit7cDtI0P
OmRuanUUfElX6UMPOF1jzMQ2+74R3XlRQwt5ey9nIZYFc93t/SmbPuqp5EFZ
duAu7kznsKokH06zNLJsWFMXsnYTXE17kC15Xhrm3ucNvIv54TBYntqvA66Q
Q6aGCph72xLGfBd+/fHMTC2t4WG0KaPDHFUz/gvPQzVv0bMe53Ne9Y7ld48L
WJ/h5zu0ljdLNtY3qt89F37Wzlq1vJwZhfKCj67U/fnQseJfVO/Wm/HiKDfr
dQxZp5439oWla61WR1f3E31vqg7LaE0P11Bo/aKNFdb0jkAyzCmujuP/O5j9
BXIYt9Y=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151063822]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeStemCounts",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->863858114],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->316558950],

Cell["Add stem counts to the plot:", "ExampleText",
 CellID->8106186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"IncludeStemCounts", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48973463],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWF9v0zAQdxMn3UBoDAZ0CIlJ8AoSGtNAogiJrTzxEXiopknbAwKNfYt9
aM9O7eTy8zl20qxApNa5y/n++e5s3/fl9cX5z+X15dny4NvV8vfF5dmfg8Wv
K43KJ0KIG/37MRP6Xem36nejlB7pv8hXg/nP9Fjol9yipWi+m6fQv20NZoDP
hZ0o3GPeDbW03DLLTdrZ9/Vovr9r6SAsZTVVuacWllvG+ikJVYPdJlTOHp6f
BMqK/xSoqGxJvxm+D4DDypKClVYArQxr783toT+BpwA/7KltAZLvRksXHY9Z
7TL7leXSqUGKtnVs0HiJ6MtLzlVXRND8cp7NVZMVuWjTbBHdstqJLqkyMlsS
bjKuh6xlED6U7i3Az4OrkoHOb4DypaU5VFht+v6/As7nHdh96xeMfef1r3as
os2zrgQYuZwCvOLyVP+XjMz02X48bQ3i9Uy1qtRgPjOCHa7NOFzMimbM7NLi
F3Z8ovrGymaxZm1y4e9PpcWfKBqZaVHB127ej7FY/1u8Znb9Qn5Z3LkG4/s6
ttan6v+IWeOZIpB7bvdx50QzfrDj3tp+5c8SeIZ6z1KRWkhocS0quFUruZMJ
hY8B3lUufikW7QvIaZ0lDfCR5b4PWKyZbiXo/u97xGie1esSyx2EWb94Mnj9
02IAJaad9o5YbDwD3R2ERu6xopH7L+Rev4zEU+Vc0d0kFqN9cvBTh9djctjI
8njNgWoviTdmBq/9Z6BK07uCvYz9AlSPknj59eAEKNLqCr9mmKtzlqrJEVMV
7sEcV1NcF2CuhuaGaT5sOkP69jJCNwVaUR2MsStF09XYVe090XU5vB5Jc5cT
7Vug4yZG64Ww+deKPbzt8rUdpaXtCDsslrfHu4V3W97RpTFNr0kFr9OH2ZTn
UA7e23muHT6MVoRpoo/C3Z+Uqk4zKKwt3bGwOzW+5bQPOU5nadj+1seGPtid
NT0Yzjk+SlYRNKS3FTv70Tpa82jVTbp6krG9ILPjnTQardaqaKcM7xdoxyHr
M9zVq9MA2097EbDoyOr5uiK1/fvJLeG0TVo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{139, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->286442394]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeStemUnits",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->30450817],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->3797094],

Cell["Omit stem units legend from plot:", "ExampleText",
 CellID->79125152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"IncludeStemUnits", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276048965],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV0tPwzAMTvMojzOPggANwTjyM0AcdtsfqCak7YBAY/8/xEmTpp7bpa2o
NmlJ7diOY39200W5W39+lbvNqpy9b8uf9Wb1O3v73hqWyBhjS/P/KJh51ubJ
/pdam/kJRgG0/bHXDu6NGYF5glaVGZQhn63ULVrNEY21ndaVGXPCdrs0U4Fr
eYydJulewyhrbqpeEXHTdxumBZHmhHRe8V96525aLsQYmGeE/0DOe2RRkVJp
WPsv3aLKQ/f5xuwwPjZpOTgGtNBciIBqqQEgZTWLai5Gx42TXIV0L0N0Yy6O
sqUbXUYgCYnoC437BTxiz1vsythrIGwcbB/p6jY+lqLSEmQEnK1DaMY0ed4W
22lZwzvgCHZ531UNkkCTze9R1EG/6vDvYn+OB52Cqj71cJ9kkUTDQFsYtWP8
svRetaRFab/2HkdEF9eH8wFwB2+WcyKeoupGIpy2D2LgCjg1St0h3eWHR977
fuPXbZ9l7TfLuD8pInZ+nUdz0zqNmdgO0HkkVXNJbDdwwJEE3evwbmkdMrMz
jSH8bootTO8/7JMleKxQPg54ivIc44HOKtfNHujQwHV9bzjcmYb7l9pHx3Nd
nOMaw93fnzmWSXmrxverYEPqUE3NaMraFxn20a6PYYzgexPefR5yxZHfd0jS
9xL3LeS+Zln2B/NWxao=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{84, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333216622]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Leaves",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->668676134],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->687157843],

Cell["Represent leaves with tally marks:", "ExampleText",
 CellID->92877752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "2.9"}], "}"}], ",", 
   RowBox[{"Leaves", "\[Rule]", "\"\<Tallies\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334917645],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1PwzAMzZp0HyAkJCS2oQGTgAsMbvwFOHHjNnGoJqTtgEBj/z8kbdK6
rtsk65hWqU2T2s8vtpPWfUs2y8+vZLNaJNPXdfKzXC1+py/fazXEO4yxuTo/
RkzdS3WXnnMpVQuvjGeNvkaqjdUNN8OCFc/1EatzoLoRGufMKDJ76HstLQxa
ZNCE0T5WrX7eKXFgRjJVlfbIjXEDrI4ukCpGB0DKzofGE0gyxe8hKWhbwGca
9wQhZDOJSWsxkhX17Cu6AfxBv4f6p4FsY2T5f1ja7Dgj2UXmKYnSyMCHbZ4b
MF8cfGnLXDZlBFxf1rNcFquCs7JMH3CLcifaRRUBbQHQhJuHyG0AHCj3hPoX
tVGJEOdHJHkNLbDqnuN/vUHIzw2jY+MXnPsCsNHtfSqNZ9dFfXptPKTtubp2
CUsQQ0vPcukqUh/pYqzM0lCW9h5vvRFigrVopi6tJp+MjXexDu39kLjud1R7
nLPqu4Seh19sm/zmykM6Ui6t+qyIiLnR0tsxa++RsAgcQs7Qo9oTsWNFCFbd
vyet/Ui/jenRy9znEBf7HsdaOPpXEu8n+ta1d+E3Pe5nXMcOlO1QQ7PdzwP7
j6Jr5dRn3CGsmfYrSfdTFGf2hXj91gvRlSN3Xiiu/PXjshuU3cwo3NNDE8kj
Yhb1EQ/JqXdmvt/2nMuh9TaOI6whrAdsH9cqghWV96Bkvd7/fpU2mSel71Rc
Swkva1SFWLN/tqq198WftLNV3d20MqWJN8yL+rcHrECzrNhFpe3Dr907LmQ0
y5Btau+mOdj/FQJjFDU6K3tTFFyc9Tf+BsPWZ3mscP09QZJ2T0nrcvufr/MH
anUktQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{91, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->499591439]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "StemExponent",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->119864228],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<StatisticalPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->245872274],

Cell[TextData[{
 "Specify a base unit of ",
 Cell[BoxData[
  SuperscriptBox["10", "1"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->51155507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StemLeafPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.2", ",", "2.5", ",", "4.1", ",", "1.6", ",", "3.8", ",", "2.6", ",", 
     "11"}], "}"}], ",", 
   RowBox[{"StemExponent", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480115699],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtPwzAQdm0nbUGFSki0QkhUYoYBGJHYYGLjD6QVUjsgUOn/D07iSy5f
nIcb6ESkxLF9j8++hy95jXbr949ot1lFi5dt9LXerL4Xz59bM6QGQoiluZ/m
wrzH5i29l3FsWv4UKmuSpzRtYF6UHdaimE+uwNxj05UwroRlFHQl7wm1ttKk
laYt97FpAyuE5ssyJYmI6cqVKqvAXCGjKkbHjIrW5ZangTKVPwQqrlvzuUTu
BHU59QzSNnDOBSBB16+pwuuxKtYfQn/6K2sIAM/fYCePOvPALC2PU3Yjri5r
yL0L0TSswq1Zxf4+xeOXrMCjSokyzYghlvmGU9BKxq2ZNL0vOp1rZtI59y30
LzztKmF9N8B/ZWkor2WZppoHuz+vQcNjw+i53cMRzJKl7lKqOcwiNcbrP1eV
axZndj6C2dCOP3jb7rCjCX4lqmcXz6y8pSgN4yJak/YkJr+rRk3bTrpjzWc0
BImYcSc90LlOgib6kGWGNNH13B3Uh/107UV9ICoVgyP79dkPZ90A+yUpBbfg
Ou2Bo83m2OdnoxDlU1n0xNLfgxGNG11dtFK2odNGQ8vnZS7NJ0+85V582Pzk
+53g8lasJqiPXqtF8cUwLWmvt1u3LwP0n2rMYuWmO2lz5qYKV2btPl8Bh8KP
eiYtyOtrfydisDf3i/pY5ade5hW/Udd3wdcvo/iMZh6yT03flpF5FsplFLW/
KO+mLrC0VvCzFu33ua2wVr8ESsopWa1m/08MfgDbfnkz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{98, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24620943]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4693],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BoxWhiskerPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/BoxWhiskerPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParetoPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:StatisticalPlots/ref/ParetoPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19885]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26431],

Cell[TextData[ButtonBox["Statistical Plots Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:StatisticalPlots/tutorial/StatisticalPlots"]], "Tutorials",
 CellID->7152]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StemLeafPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 36.7249400}", "context" -> 
    "StatisticalPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Statistical Plots Package Symbol", "language" -> "en", "paclet" -> 
    "StatisticalPlots Package", "status" -> "None", "summary" -> 
    "StemLeafPlot[data] creates a stem-and-leaf plot for the real-valued \
vector data. StemLeafPlot[data_1, data_2] creates a side-by-side \
stem-and-leaf plot for the vectors data_1 and data_2.", "synonyms" -> {}, 
    "title" -> "StemLeafPlot", "type" -> "Symbol", "uri" -> 
    "StatisticalPlots/ref/StemLeafPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6501, 208, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85887296]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25334, 799}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1385, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2008, 63, 50, 1, 70, "ObjectName",
 CellID->28978],
Cell[2061, 66, 1163, 39, 70, "Usage",
 CellID->21617]
}, Open  ]],
Cell[CellGroupData[{
Cell[3261, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3739, 127, 199, 5, 70, "Notes",
 CellID->617304553],
Cell[3941, 134, 147, 4, 70, "Notes",
 CellID->553467341],
Cell[4091, 140, 274, 9, 70, "Notes",
 CellID->4015],
Cell[4368, 151, 2096, 52, 70, "3ColumnTableMod",
 CellID->16626]
}, Closed]],
Cell[CellGroupData[{
Cell[6501, 208, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85887296],
Cell[CellGroupData[{
Cell[6885, 222, 148, 5, 70, "ExampleSection",
 CellID->539086200],
Cell[7036, 229, 141, 4, 70, "Input",
 CellID->109099088],
Cell[7180, 235, 123, 4, 70, "ExampleText",
 CellID->11270735],
Cell[CellGroupData[{
Cell[7328, 243, 227, 7, 28, "Input",
 CellID->85151077],
Cell[7558, 252, 1100, 22, 114, "Output",
 Evaluatable->False,
 CellID->31784027]
}, Open  ]],
Cell[8673, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->708025970],
Cell[8801, 282, 141, 4, 70, "Input",
 CellID->355903335],
Cell[8945, 288, 158, 5, 70, "ExampleText",
 CellID->38491534],
Cell[CellGroupData[{
Cell[9128, 297, 304, 10, 28, "Input",
 CellID->769612083],
Cell[9435, 309, 1318, 26, 114, "Output",
 Evaluatable->False,
 CellID->931996939]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10802, 341, 218, 7, 70, "ExampleSection",
 CellID->29022],
Cell[CellGroupData[{
Cell[11045, 352, 233, 7, 70, "ExampleSubsection",
 CellID->502684921],
Cell[11281, 361, 141, 4, 70, "Input",
 CellID->573185034],
Cell[11425, 367, 164, 4, 70, "ExampleText",
 CellID->755057619],
Cell[CellGroupData[{
Cell[11614, 375, 362, 11, 70, "Input",
 CellID->41451835],
Cell[11979, 388, 1012, 21, 70, "Output",
 Evaluatable->False,
 CellID->326133065]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13040, 415, 238, 7, 70, "ExampleSubsection",
 CellID->306150385],
Cell[13281, 424, 141, 4, 70, "Input",
 CellID->257316178],
Cell[13425, 430, 145, 4, 70, "ExampleText",
 CellID->617151523],
Cell[CellGroupData[{
Cell[13595, 438, 291, 9, 70, "Input",
 CellID->119666391],
Cell[13889, 449, 1196, 24, 70, "Output",
 Evaluatable->False,
 CellID->151063822]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15134, 479, 238, 7, 70, "ExampleSubsection",
 CellID->863858114],
Cell[15375, 488, 141, 4, 70, "Input",
 CellID->316558950],
Cell[15519, 494, 69, 1, 70, "ExampleText",
 CellID->8106186],
Cell[CellGroupData[{
Cell[15613, 499, 303, 9, 70, "Input",
 CellID->48973463],
Cell[15919, 510, 1285, 25, 70, "Output",
 Evaluatable->False,
 CellID->286442394]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17253, 541, 236, 7, 70, "ExampleSubsection",
 CellID->30450817],
Cell[17492, 550, 139, 4, 70, "Input",
 CellID->3797094],
Cell[17634, 556, 75, 1, 70, "ExampleText",
 CellID->79125152],
Cell[CellGroupData[{
Cell[17734, 561, 304, 9, 70, "Input",
 CellID->276048965],
Cell[18041, 572, 902, 19, 70, "Output",
 Evaluatable->False,
 CellID->333216622]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18992, 597, 227, 7, 70, "ExampleSubsection",
 CellID->668676134],
Cell[19222, 606, 141, 4, 70, "Input",
 CellID->687157843],
Cell[19366, 612, 76, 1, 70, "ExampleText",
 CellID->92877752],
Cell[CellGroupData[{
Cell[19467, 617, 304, 9, 70, "Input",
 CellID->334917645],
Cell[19774, 628, 1073, 22, 70, "Output",
 Evaluatable->False,
 CellID->499591439]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20896, 656, 233, 7, 70, "ExampleSubsection",
 CellID->119864228],
Cell[21132, 665, 141, 4, 70, "Input",
 CellID->245872274],
Cell[21276, 671, 149, 6, 70, "ExampleText",
 CellID->51155507],
Cell[CellGroupData[{
Cell[21450, 681, 295, 9, 70, "Input",
 CellID->480115699],
Cell[21748, 692, 986, 20, 70, "Output",
 Evaluatable->False,
 CellID->24620943]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22807, 720, 310, 9, 70, "SeeAlsoSection",
 CellID->4693],
Cell[23120, 731, 501, 17, 70, "SeeAlso",
 CellID->19885]
}, Open  ]],
Cell[CellGroupData[{
Cell[23658, 753, 314, 9, 70, "TutorialsSection",
 CellID->26431],
Cell[23975, 764, 171, 4, 70, "Tutorials",
 CellID->7152]
}, Open  ]],
Cell[24161, 771, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

