(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6444,        235]
NotebookOptionsPosition[      4697,        177]
NotebookOutlinePosition[      5689,        206]
CellTagsIndexPosition[      5646,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statfarad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statfarad"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Statfarad\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abfarad", "ObjectName",
 CellID->7268],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abfarad"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric capacitance in the CGS system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7752]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abfarad"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "9"], " ", 
   ButtonBox["Farad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Farad"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->10704],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abfarad"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abfarad"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15818],

Cell[TextData[{
 Cell[BoxData["Abfarad"], "InlineFormula"],
 " is typically abbreviated as abF."
}], "Notes",
 CellID->28526300]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18514],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Statfarad",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statfarad"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1813259]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24471],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->7342]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abfarad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.0220018}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Abfarad is a unit of electric capacitance in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abfarad", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abfarad"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1140, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1763, 58, 44, 1, 70, "ObjectName",
 CellID->7268],
Cell[1810, 61, 348, 10, 70, "Usage",
 CellID->7752]
}, Open  ]],
Cell[CellGroupData[{
Cell[2195, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2673, 93, 298, 11, 70, "Notes",
 CellID->10704],
Cell[2974, 106, 505, 19, 70, "Notes",
 CellID->15818],
Cell[3482, 127, 128, 4, 70, "Notes",
 CellID->28526300]
}, Closed]],
Cell[CellGroupData[{
Cell[3647, 136, 311, 9, 70, "SeeAlsoSection",
 CellID->18514],
Cell[3961, 147, 206, 6, 70, "SeeAlso",
 CellID->1813259]
}, Open  ]],
Cell[CellGroupData[{
Cell[4204, 158, 314, 9, 70, "TutorialsSection",
 CellID->24471],
Cell[4521, 169, 134, 3, 70, "Tutorials",
 CellID->7342]
}, Open  ]],
Cell[4670, 175, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

