(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6439,        235]
NotebookOptionsPosition[      4707,        178]
NotebookOutlinePosition[      5684,        206]
CellTagsIndexPosition[      5641,        203]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stathenry" :> 
          Documentation`HelpLookup["paclet:Units/ref/Stathenry"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stathenry\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abhenry", "ObjectName",
 CellID->26529],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abhenry"], "InlineFormula"],
     " \[LineSeparator]is a unit of inductance in the CGS system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abhenry"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "9"}]], " ", 
   ButtonBox["Henry",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Henry"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6405],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abhenry"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abhenry"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24742],

Cell[TextData[{
 Cell[BoxData["Abhenry"], "InlineFormula"],
 " is typically abbreviated as abH."
}], "Notes",
 CellID->28526300]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31313],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Stathenry",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Stathenry"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26215],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->14249]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abhenry - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.1938812}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Abhenry is a unit of inductance in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abhenry", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abhenry"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1140, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1763, 58, 45, 1, 70, "ObjectName",
 CellID->26529],
Cell[1811, 61, 339, 10, 70, "Usage",
 CellID->26610]
}, Open  ]],
Cell[CellGroupData[{
Cell[2187, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2665, 93, 317, 12, 70, "Notes",
 CellID->6405],
Cell[2985, 107, 505, 19, 70, "Notes",
 CellID->24742],
Cell[3493, 128, 128, 4, 70, "Notes",
 CellID->28526300]
}, Closed]],
Cell[CellGroupData[{
Cell[3658, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->31313],
Cell[3972, 148, 204, 6, 70, "SeeAlso",
 CellID->29742]
}, Open  ]],
Cell[CellGroupData[{
Cell[4213, 159, 314, 9, 70, "TutorialsSection",
 CellID->26215],
Cell[4530, 170, 135, 3, 70, "Tutorials",
 CellID->14249]
}, Open  ]],
Cell[4680, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

