(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6882,        254]
NotebookOptionsPosition[      5076,        194]
NotebookOutlinePosition[      6071,        223]
CellTagsIndexPosition[      6028,        220]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Siemens" :> 
          Documentation`HelpLookup["paclet:Units/ref/Siemens"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Siemens\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abmho", "ObjectName",
 CellID->22027],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abmho"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric conductance in the CGS system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abmho"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "9"], "/", 
   ButtonBox["Ohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ohm"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->11183],

Cell[TextData[{
 Cell[BoxData["Abmho"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "9"], " ", 
   ButtonBox["Mho",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mho"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15426],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abmho"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abmho"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24275],

Cell[TextData[{
 Cell[BoxData["Abmho"], "InlineFormula"],
 " is typically abbreviated as ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", "a\[CapitalOmega]", ")"}], 
   RowBox[{"-", "1"}]]], "InlineFormula"],
 " or aS."
}], "Notes",
 CellID->179905296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26935],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Siemens",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Siemens"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10458]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6769],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->23828]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abmho - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.3657606}", "context" -> "Units`", 
    "keywords" -> {"absiemens"}, "index" -> True, "label" -> 
    "Units Package Symbol", "language" -> "en", "paclet" -> "Units Package", 
    "status" -> "None", "summary" -> 
    "Abmho is a unit of electric conductance in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abmho", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abmho"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1126, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1749, 57, 43, 1, 70, "ObjectName",
 CellID->22027],
Cell[1795, 60, 347, 10, 70, "Usage",
 CellID->15907]
}, Open  ]],
Cell[CellGroupData[{
Cell[2179, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2657, 92, 292, 11, 70, "Notes",
 CellID->11183],
Cell[2952, 105, 281, 11, 70, "Notes",
 CellID->15426],
Cell[3236, 118, 501, 19, 70, "Notes",
 CellID->24275],
Cell[3740, 139, 255, 9, 70, "Notes",
 CellID->179905296]
}, Closed]],
Cell[CellGroupData[{
Cell[4032, 153, 311, 9, 70, "SeeAlsoSection",
 CellID->26935],
Cell[4346, 164, 200, 6, 70, "SeeAlso",
 CellID->10458]
}, Open  ]],
Cell[CellGroupData[{
Cell[4583, 175, 313, 9, 70, "TutorialsSection",
 CellID->6769],
Cell[4899, 186, 135, 3, 70, "Tutorials",
 CellID->23828]
}, Open  ]],
Cell[5049, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

