(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6469,        237]
NotebookOptionsPosition[      4716,        179]
NotebookOutlinePosition[      5713,        208]
CellTagsIndexPosition[      5670,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Statvolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statvolt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Statvolt\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abvolt", "ObjectName",
 CellID->30608],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Abvolt"], "InlineFormula"],
     " \[LineSeparator]is a unit of electric potential difference in the CGS \
system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Abvolt"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "8"}]], " ", 
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->25636],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Abvolt"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Abvolt"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10343],

Cell[TextData[{
 Cell[BoxData["Abvolt"], "InlineFormula"],
 " is typically abbreviated as abV."
}], "Notes",
 CellID->179905296]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13719],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Statvolt",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Statvolt"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30203]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3690],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->20975]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abvolt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 44.7095194}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Abvolt is a unit of electric potential difference in the CGS system.", 
    "synonyms" -> {}, "title" -> "Abvolt", "type" -> "Symbol", "uri" -> 
    "Units/ref/Abvolt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1137, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1760, 58, 44, 1, 70, "ObjectName",
 CellID->30608],
Cell[1807, 61, 359, 11, 70, "Usage",
 CellID->17868]
}, Open  ]],
Cell[CellGroupData[{
Cell[2203, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2681, 94, 315, 12, 70, "Notes",
 CellID->25636],
Cell[2999, 108, 503, 19, 70, "Notes",
 CellID->10343],
Cell[3505, 129, 128, 4, 70, "Notes",
 CellID->179905296]
}, Closed]],
Cell[CellGroupData[{
Cell[3670, 138, 311, 9, 70, "SeeAlsoSection",
 CellID->13719],
Cell[3984, 149, 202, 6, 70, "SeeAlso",
 CellID->30203]
}, Open  ]],
Cell[CellGroupData[{
Cell[4223, 160, 313, 9, 70, "TutorialsSection",
 CellID->3690],
Cell[4539, 171, 135, 3, 70, "Tutorials",
 CellID->20975]
}, Open  ]],
Cell[4689, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

