(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8043,        286]
NotebookOptionsPosition[      6354,        230]
NotebookOutlinePosition[      7286,        257]
CellTagsIndexPosition[      7243,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hectare" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hectare"], "Acre" :> 
          Documentation`HelpLookup["paclet:Units/ref/Acre"], "Rood" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rood"], "Section" :> 
          Documentation`HelpLookup["paclet:Units/ref/Section"], "Township" :> 
          Documentation`HelpLookup["paclet:Units/ref/Township"], "Barn" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barn"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hectare\"\>", 2->"\<\"Acre\"\>", 
       3->"\<\"Rood\"\>", 4->"\<\"Section\"\>", 5->"\<\"Township\"\>", 
       6->"\<\"Barn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Are", "ObjectName",
 CellID->18468],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Are"], "InlineFormula"],
     " \[LineSeparator]is a unit of area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Are"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"100", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->27109],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Are"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Are"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13845],

Cell[TextData[{
 Cell[BoxData["Are"], "InlineFormula"],
 " is typically abbreviated as a."
}], "Notes",
 CellID->25883153]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16642],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hectare",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hectare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Acre",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Acre"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rood",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rood"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Section",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Section"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Township",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Township"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barn",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14587],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->1562]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Are - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 8, 51.7096986}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Are is a unit of area.", "synonyms" -> {}, "title" -> "Are",
     "type" -> "Symbol", "uri" -> "Units/ref/Are"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1618, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2241, 64, 41, 1, 70, "ObjectName",
 CellID->18468],
Cell[2285, 67, 311, 10, 70, "Usage",
 CellID->23926]
}, Open  ]],
Cell[CellGroupData[{
Cell[2633, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3111, 99, 298, 11, 70, "Notes",
 CellID->27109],
Cell[3412, 112, 497, 19, 70, "Notes",
 CellID->13845],
Cell[3912, 133, 122, 4, 70, "Notes",
 CellID->25883153]
}, Closed]],
Cell[CellGroupData[{
Cell[4071, 142, 311, 9, 70, "SeeAlsoSection",
 CellID->16642],
Cell[4385, 153, 1439, 53, 70, "SeeAlso",
 CellID->21290]
}, Open  ]],
Cell[CellGroupData[{
Cell[5861, 211, 314, 9, 70, "TutorialsSection",
 CellID->14587],
Cell[6178, 222, 134, 3, 70, "Tutorials",
 CellID->1562]
}, Open  ]],
Cell[6327, 228, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

