(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8041,        288]
NotebookOptionsPosition[      6300,        230]
NotebookOutlinePosition[      7234,        257]
CellTagsIndexPosition[      7191,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Therm" :> Documentation`HelpLookup["paclet:Units/ref/Therm"], 
          "Calorie" :> Documentation`HelpLookup["paclet:Units/ref/Calorie"], 
          "ElectronVolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], "Erg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Erg"], "Rydberg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rydberg"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Therm\"\>", 2->"\<\"Calorie\"\>", 
       3->"\<\"ElectronVolt\"\>", 4->"\<\"Erg\"\>", 
       5->"\<\"Rydberg\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BTU", "ObjectName",
 CellID->18500],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["BTU"], "InlineFormula"],
     " \[LineSeparator]is a unit of energy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BTU"], "InlineFormula"],
 " is an abbreviation for ",
 Cell[BoxData[
  ButtonBox["BritishThermalUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/BritishThermalUnit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19413],

Cell[TextData[{
 Cell[BoxData["BTU"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1055.06", " ", 
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->24574],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "BTU"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "BTU"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2625],

Cell[TextData[{
 Cell[BoxData["BTU"], "InlineFormula"],
 " is written in the literature as Btu."
}], "Notes",
 CellID->10926]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21986],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Therm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Therm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Calorie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Calorie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronVolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ElectronVolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Erg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rydberg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rydberg"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12664],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21469]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BTU - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 15.3040526}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "BTU is a unit of energy.", "synonyms" -> {}, "title" -> 
    "BTU", "type" -> "Symbol", "uri" -> "Units/ref/BTU"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1539, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2162, 63, 41, 1, 70, "ObjectName",
 CellID->18500],
Cell[2206, 66, 313, 10, 70, "Usage",
 CellID->19386]
}, Open  ]],
Cell[CellGroupData[{
Cell[2556, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3034, 98, 263, 9, 70, "Notes",
 CellID->19413],
Cell[3300, 109, 288, 10, 70, "Notes",
 CellID->24574],
Cell[3591, 121, 496, 19, 70, "Notes",
 CellID->2625],
Cell[4090, 142, 125, 4, 70, "Notes",
 CellID->10926]
}, Closed]],
Cell[CellGroupData[{
Cell[4252, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->21986],
Cell[4566, 162, 1203, 44, 70, "SeeAlso",
 CellID->2614]
}, Open  ]],
Cell[CellGroupData[{
Cell[5806, 211, 314, 9, 70, "TutorialsSection",
 CellID->12664],
Cell[6123, 222, 135, 3, 70, "Tutorials",
 CellID->21469]
}, Open  ]],
Cell[6273, 228, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

