(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8583,        300]
NotebookOptionsPosition[      6892,        244]
NotebookOutlinePosition[      7827,        271]
CellTagsIndexPosition[      7784,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atmosphere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Atmosphere"], "Torr" :> 
          Documentation`HelpLookup["paclet:Units/ref/Torr"], "InchMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "PSI" :> 
          Documentation`HelpLookup["paclet:Units/ref/PSI"], "Barye" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barye"], 
          "MillimeterMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"], 
          "PoundsPerSquareInch" :> 
          Documentation`HelpLookup[
           "paclet:Units/ref/PoundsPerSquareInch"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atmosphere\"\>", 2->"\<\"Torr\"\>", 
       3->"\<\"InchMercury\"\>", 4->"\<\"PSI\"\>", 5->"\<\"Barye\"\>", 
       6->"\<\"MillimeterMercury\"\>", 
       7->"\<\"PoundsPerSquareInch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bar", "ObjectName",
 CellID->23116],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bar"], "InlineFormula"],
     " \[LineSeparator]is a unit of pressure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14560]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Bar"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", "5"], "  ", 
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->14111],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Bar"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Bar"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28832],

Cell[TextData[{
 Cell[BoxData["Bar"], "InlineFormula"],
 " is written in the literature as bar."
}], "Notes",
 CellID->24782]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25689],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Atmosphere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Atmosphere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Torr",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Torr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InchMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/InchMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PSI",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PSI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barye",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barye"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MillimeterMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MillimeterMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundsPerSquareInch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundsPerSquareInch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19938],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21184]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 6.8194604}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Bar is a unit of pressure.", "synonyms" -> {}, "title" -> 
    "Bar", "type" -> "Symbol", "uri" -> "Units/ref/Bar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1844, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2467, 69, 41, 1, 70, "ObjectName",
 CellID->23116],
Cell[2511, 72, 315, 10, 70, "Usage",
 CellID->14560]
}, Open  ]],
Cell[CellGroupData[{
Cell[2863, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3341, 104, 297, 11, 70, "Notes",
 CellID->14111],
Cell[3641, 117, 497, 19, 70, "Notes",
 CellID->28832],
Cell[4141, 138, 125, 4, 70, "Notes",
 CellID->24782]
}, Closed]],
Cell[CellGroupData[{
Cell[4303, 147, 311, 9, 70, "SeeAlsoSection",
 CellID->25689],
Cell[4617, 158, 1744, 62, 70, "SeeAlso",
 CellID->24435]
}, Open  ]],
Cell[CellGroupData[{
Cell[6398, 225, 314, 9, 70, "TutorialsSection",
 CellID->19938],
Cell[6715, 236, 135, 3, 70, "Tutorials",
 CellID->21184]
}, Open  ]],
Cell[6865, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

