(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8069,        287]
NotebookOptionsPosition[      6383,        231]
NotebookOutlinePosition[      7318,        258]
CellTagsIndexPosition[      7275,        255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Acre" :> Documentation`HelpLookup["paclet:Units/ref/Acre"], 
          "Hectare" :> Documentation`HelpLookup["paclet:Units/ref/Hectare"], 
          "Are" :> Documentation`HelpLookup["paclet:Units/ref/Are"], "Rood" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rood"], "Section" :> 
          Documentation`HelpLookup["paclet:Units/ref/Section"], "Township" :> 
          Documentation`HelpLookup["paclet:Units/ref/Township"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Acre\"\>", 2->"\<\"Hectare\"\>", 
       3->"\<\"Are\"\>", 4->"\<\"Rood\"\>", 5->"\<\"Section\"\>", 
       6->"\<\"Township\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Barn", "ObjectName",
 CellID->9203],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Barn"], "InlineFormula"],
     " \[LineSeparator]is a unit of area."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Barn"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["10", 
    RowBox[{"-", "28"}]], " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->16745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Barn"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Barn"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30729],

Cell[TextData[{
 Cell[BoxData["Barn"], "InlineFormula"],
 " is typically abbreviated as b."
}], "Notes",
 CellID->12549]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Acre",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Acre"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hectare",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hectare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Are",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Are"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rood",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rood"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Section",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Section"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Township",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Township"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7724],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16979]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Barn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 7.0069652}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Barn is a unit of area.", "synonyms" -> {}, "title" -> 
    "Barn", "type" -> "Symbol", "uri" -> "Units/ref/Barn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1604, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2227, 63, 41, 1, 70, "ObjectName",
 CellID->9203],
Cell[2271, 66, 310, 10, 70, "Usage",
 CellID->824]
}, Open  ]],
Cell[CellGroupData[{
Cell[2618, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3096, 98, 344, 13, 70, "Notes",
 CellID->16745],
Cell[3443, 113, 499, 19, 70, "Notes",
 CellID->30729],
Cell[3945, 134, 120, 4, 70, "Notes",
 CellID->12549]
}, Closed]],
Cell[CellGroupData[{
Cell[4102, 143, 311, 9, 70, "SeeAlsoSection",
 CellID->19891],
Cell[4416, 154, 1437, 53, 70, "SeeAlso",
 CellID->17411]
}, Open  ]],
Cell[CellGroupData[{
Cell[5890, 212, 313, 9, 70, "TutorialsSection",
 CellID->7724],
Cell[6206, 223, 135, 3, 70, "Tutorials",
 CellID->16979]
}, Open  ]],
Cell[6356, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

