(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8571,        300]
NotebookOptionsPosition[      6873,        244]
NotebookOutlinePosition[      7816,        271]
CellTagsIndexPosition[      7773,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bar" :> Documentation`HelpLookup["paclet:Units/ref/Bar"], 
          "Atmosphere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Atmosphere"], "Torr" :> 
          Documentation`HelpLookup["paclet:Units/ref/Torr"], 
          "MillimeterMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"], 
          "InchMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "PSI" :> 
          Documentation`HelpLookup["paclet:Units/ref/PSI"], 
          "PoundsPerSquareInch" :> 
          Documentation`HelpLookup[
           "paclet:Units/ref/PoundsPerSquareInch"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bar\"\>", 2->"\<\"Atmosphere\"\>", 
       3->"\<\"Torr\"\>", 4->"\<\"MillimeterMercury\"\>", 
       5->"\<\"InchMercury\"\>", 6->"\<\"PSI\"\>", 
       7->"\<\"PoundsPerSquareInch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Barye", "ObjectName",
 CellID->24582],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Barye"], "InlineFormula"],
     " \[LineSeparator]is a unit of pressure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32533]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Barye"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pascal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pascal"], "/", "10"}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->6166],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Barye"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Barye"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1468],

Cell[TextData[{
 Cell[BoxData["Barye"], "InlineFormula"],
 " is typically abbreviated as ba."
}], "Notes",
 CellID->218783628]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6261],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bar",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Bar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Atmosphere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Atmosphere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Torr",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Torr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MillimeterMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MillimeterMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InchMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/InchMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PSI",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PSI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundsPerSquareInch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundsPerSquareInch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16497]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->319],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->13828]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Barye - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 7.3819748}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Barye is a unit of pressure.", "synonyms" -> {}, "title" -> 
    "Barye", "type" -> "Symbol", "uri" -> "Units/ref/Barye"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1849, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2472, 70, 43, 1, 70, "ObjectName",
 CellID->24582],
Cell[2518, 73, 317, 10, 70, "Usage",
 CellID->32533]
}, Open  ]],
Cell[CellGroupData[{
Cell[2872, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3350, 105, 272, 10, 70, "Notes",
 CellID->6166],
Cell[3625, 117, 500, 19, 70, "Notes",
 CellID->1468],
Cell[4128, 138, 126, 4, 70, "Notes",
 CellID->218783628]
}, Closed]],
Cell[CellGroupData[{
Cell[4291, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->6261],
Cell[4604, 158, 1740, 62, 70, "SeeAlso",
 CellID->16497]
}, Open  ]],
Cell[CellGroupData[{
Cell[6381, 225, 312, 9, 70, "TutorialsSection",
 CellID->319],
Cell[6696, 236, 135, 3, 70, "Tutorials",
 CellID->13828]
}, Open  ]],
Cell[6846, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

