(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7593,        264]
NotebookOptionsPosition[      5907,        209]
NotebookOutlinePosition[      6889,        237]
CellTagsIndexPosition[      6846,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rutherford" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rutherford"], "Curie" :> 
          Documentation`HelpLookup["paclet:Units/ref/Curie"], "GrayDose" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrayDose"], "Rad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rad"], "Rontgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rontgen"], "Roentgen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Roentgen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rutherford\"\>", 2->"\<\"Curie\"\>",
        3->"\<\"GrayDose\"\>", 4->"\<\"Rad\"\>", 5->"\<\"Rontgen\"\>", 
       6->"\<\"Roentgen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Becquerel", "ObjectName",
 CellID->25830],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Becquerel"], "InlineFormula"],
     " \[LineSeparator]",
     "is the derived SI unit of radioactivity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16724]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Becquerel"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1", "/", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4854],

Cell[TextData[{
 Cell[BoxData["Becquerel"], "InlineFormula"],
 " is typically abbreviated as Bq."
}], "Notes",
 CellID->13179]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22923],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rutherford",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rutherford"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Curie",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Curie"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayDose",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrayDose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rontgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rontgen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roentgen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Roentgen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->130017045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29472],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->27718]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Becquerel - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 7.7101082}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Becquerel is the derived SI unit of radioactivity.", 
    "synonyms" -> {}, "title" -> "Becquerel", "type" -> "Symbol", "uri" -> 
    "Units/ref/Becquerel"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1639, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2262, 64, 47, 1, 70, "ObjectName",
 CellID->25830],
Cell[2312, 67, 348, 11, 70, "Usage",
 CellID->16724]
}, Open  ]],
Cell[CellGroupData[{
Cell[2697, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3175, 100, 264, 10, 70, "Notes",
 CellID->4854],
Cell[3442, 112, 126, 4, 70, "Notes",
 CellID->13179]
}, Closed]],
Cell[CellGroupData[{
Cell[3605, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->22923],
Cell[3919, 132, 1457, 53, 70, "SeeAlso",
 CellID->130017045]
}, Open  ]],
Cell[CellGroupData[{
Cell[5413, 190, 314, 9, 70, "TutorialsSection",
 CellID->29472],
Cell[5730, 201, 135, 3, 70, "Tutorials",
 CellID->27718]
}, Open  ]],
Cell[5880, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

