(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7171,        260]
NotebookOptionsPosition[      5479,        204]
NotebookOutlinePosition[      6421,        231]
CellTagsIndexPosition[      6378,        228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fathom" :> Documentation`HelpLookup["paclet:Units/ref/Fathom"],
           "NauticalMile" :> 
          Documentation`HelpLookup["paclet:Units/ref/NauticalMile"], "Rope" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rope"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fathom\"\>", 
       2->"\<\"NauticalMile\"\>", 3->"\<\"Rope\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cable", "ObjectName",
 CellID->31354],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Cable"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Cable"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"219.456", " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->21429],

Cell[TextData[{
 Cell[BoxData["Cable"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"720", " ", 
   ButtonBox["Foot",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Foot"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6696],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Cable"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Cable"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30423]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7572],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fathom",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fathom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NauticalMile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NauticalMile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rope",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rope"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8800],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->9716]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 22.4761112}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Cable is a unit of length.", "synonyms" -> {}, "title" -> 
    "Cable", "type" -> "Symbol", "uri" -> "Units/ref/Cable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1337, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1960, 60, 43, 1, 70, "ObjectName",
 CellID->31354],
Cell[2006, 63, 314, 10, 70, "Usage",
 CellID->8343]
}, Open  ]],
Cell[CellGroupData[{
Cell[2357, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2835, 95, 290, 10, 70, "Notes",
 CellID->21429],
Cell[3128, 107, 258, 10, 70, "Notes",
 CellID->6696],
Cell[3389, 119, 501, 19, 70, "Notes",
 CellID->30423]
}, Closed]],
Cell[CellGroupData[{
Cell[3927, 143, 310, 9, 70, "SeeAlsoSection",
 CellID->7572],
Cell[4240, 154, 710, 26, 70, "SeeAlso",
 CellID->11523]
}, Open  ]],
Cell[CellGroupData[{
Cell[4987, 185, 313, 9, 70, "TutorialsSection",
 CellID->8800],
Cell[5303, 196, 134, 3, 70, "Tutorials",
 CellID->9716]
}, Open  ]],
Cell[5452, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

