(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8138,        285]
NotebookOptionsPosition[      6436,        229]
NotebookOutlinePosition[      7386,        256]
CellTagsIndexPosition[      7343,        253]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BritishThermalUnit" :> 
          Documentation`HelpLookup["paclet:Units/ref/BritishThermalUnit"], 
          "BTU" :> Documentation`HelpLookup["paclet:Units/ref/BTU"], "Therm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Therm"], "ElectronVolt" :> 
          Documentation`HelpLookup["paclet:Units/ref/ElectronVolt"], "Erg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Erg"], "Rydberg" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rydberg"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BritishThermalUnit\"\>", 
       2->"\<\"BTU\"\>", 3->"\<\"Therm\"\>", 4->"\<\"ElectronVolt\"\>", 
       5->"\<\"Erg\"\>", 6->"\<\"Rydberg\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Calorie", "ObjectName",
 CellID->7373],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Calorie"], "InlineFormula"],
     " \[LineSeparator]is a unit of energy."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Calorie"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"4.1868", " ", 
   ButtonBox["Joule",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Joule"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->7048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Calorie"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Calorie"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15124],

Cell[TextData[{
 Cell[BoxData["Calorie"], "InlineFormula"],
 " is typically abbreviated as cal."
}], "Notes",
 CellID->354470042]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18228],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BritishThermalUnit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BritishThermalUnit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BTU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/BTU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Therm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Therm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElectronVolt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ElectronVolt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Erg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rydberg",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rydberg"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->360],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->14126]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Calorie - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 22.8198700}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Calorie is a unit of energy.", "synonyms" -> {}, "title" -> 
    "Calorie", "type" -> "Symbol", "uri" -> "Units/ref/Calorie"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1660, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2283, 64, 44, 1, 70, "ObjectName",
 CellID->7373],
Cell[2330, 67, 315, 10, 70, "Usage",
 CellID->397]
}, Open  ]],
Cell[CellGroupData[{
Cell[2682, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3160, 99, 290, 10, 70, "Notes",
 CellID->7048],
Cell[3453, 111, 505, 19, 70, "Notes",
 CellID->15124],
Cell[3961, 132, 129, 4, 70, "Notes",
 CellID->354470042]
}, Closed]],
Cell[CellGroupData[{
Cell[4127, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->18228],
Cell[4441, 152, 1466, 53, 70, "SeeAlso",
 CellID->4741]
}, Open  ]],
Cell[CellGroupData[{
Cell[5944, 210, 312, 9, 70, "TutorialsSection",
 CellID->360],
Cell[6259, 221, 135, 3, 70, "Tutorials",
 CellID->14126]
}, Open  ]],
Cell[6409, 227, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

