(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6695,        243]
NotebookOptionsPosition[      4982,        187]
NotebookOutlinePosition[      5940,        214]
CellTagsIndexPosition[      5897,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hefner" :> Documentation`HelpLookup["paclet:Units/ref/Hefner"],
           "FootCandle" :> 
          Documentation`HelpLookup["paclet:Units/ref/FootCandle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hefner\"\>", 
       2->"\<\"FootCandle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Candle", "ObjectName",
 CellID->10913],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Candle"], "InlineFormula"],
     " \[LineSeparator]is a unit of luminous intensity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24025]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Candle"], "InlineFormula"],
 " is equivalent to one ",
 Cell[BoxData[
  ButtonBox["Candela",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Candela"]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->17538],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Candle"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Candle"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6342],

Cell[TextData[{
 Cell[BoxData["Candle"], "InlineFormula"],
 " is typically abbreviated cd."
}], "Notes",
 CellID->565682013]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22741],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hefner",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hefner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FootCandle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FootCandle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10160],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->10883]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Candle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 23.1792542}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Candle is a unit of luminous intensity.", "synonyms" -> {}, 
    "title" -> "Candle", "type" -> "Symbol", "uri" -> "Units/ref/Candle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1240, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1863, 59, 44, 1, 70, "ObjectName",
 CellID->10913],
Cell[1910, 62, 328, 10, 70, "Usage",
 CellID->24025]
}, Open  ]],
Cell[CellGroupData[{
Cell[2275, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2753, 94, 253, 9, 70, "Notes",
 CellID->17538],
Cell[3009, 105, 502, 19, 70, "Notes",
 CellID->6342],
Cell[3514, 126, 124, 4, 70, "Notes",
 CellID->565682013]
}, Closed]],
Cell[CellGroupData[{
Cell[3675, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->22741],
Cell[3989, 146, 462, 17, 70, "SeeAlso",
 CellID->4734]
}, Open  ]],
Cell[CellGroupData[{
Cell[4488, 168, 314, 9, 70, "TutorialsSection",
 CellID->10160],
Cell[4805, 179, 135, 3, 70, "Tutorials",
 CellID->10883]
}, Open  ]],
Cell[4955, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

