(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7151,        254]
NotebookOptionsPosition[      5434,        198]
NotebookOutlinePosition[      6389,        225]
CellTagsIndexPosition[      6346,        222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fahrenheit" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fahrenheit"], "Rankine" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rankine"], "Centigrade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centigrade"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fahrenheit\"\>", 
       2->"\<\"Rankine\"\>", 3->"\<\"Centigrade\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Celsius", "ObjectName",
 CellID->15026],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Celsius"], "InlineFormula"],
     " \[LineSeparator]is a unit of temperature."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A temperature range of one ",
 Cell[BoxData["Celsius"], "InlineFormula"],
 " is equivalent to one ",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->13700],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvertTemperature",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ConvertTemperature"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", " ", "Celsius", ",", " ", 
    StyleBox["newscale", "TI"]}], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " degrees ",
 Cell[BoxData["Celsius"], "InlineFormula"],
 " into the temperature scale ",
 Cell[BoxData[
  StyleBox["newscale", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->539649999],

Cell[TextData[{
 Cell[BoxData["Celsius"], "InlineFormula"],
 " is typically abbreviated as C."
}], "Notes",
 CellID->313182315]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22877],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fahrenheit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fahrenheit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rankine",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rankine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centigrade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centigrade"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21526]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13479],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->24441]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Celsius - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 23.5073876}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Celsius is a unit of temperature.", "synonyms" -> {}, 
    "title" -> "Celsius", "type" -> "Symbol", "uri" -> "Units/ref/Celsius"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1352, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1975, 60, 45, 1, 70, "ObjectName",
 CellID->15026],
Cell[2023, 63, 322, 10, 70, "Usage",
 CellID->20525]
}, Open  ]],
Cell[CellGroupData[{
Cell[2382, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2860, 95, 284, 10, 70, "Notes",
 CellID->13700],
Cell[3147, 107, 555, 19, 70, "Notes",
 CellID->539649999],
Cell[3705, 128, 127, 4, 70, "Notes",
 CellID->313182315]
}, Closed]],
Cell[CellGroupData[{
Cell[3869, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->22877],
Cell[4183, 148, 720, 26, 70, "SeeAlso",
 CellID->21526]
}, Open  ]],
Cell[CellGroupData[{
Cell[4940, 179, 314, 9, 70, "TutorialsSection",
 CellID->13479],
Cell[5257, 190, 135, 3, 70, "Tutorials",
 CellID->24441]
}, Open  ]],
Cell[5407, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

