(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6966,        247]
NotebookOptionsPosition[      5297,        192]
NotebookOutlinePosition[      6269,        220]
CellTagsIndexPosition[      6226,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Celsius" :> 
          Documentation`HelpLookup["paclet:Units/ref/Celsius"], "Fahrenheit" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fahrenheit"], "Rankine" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rankine"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Celsius\"\>", 
       2->"\<\"Fahrenheit\"\>", 3->"\<\"Rankine\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Centigrade", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Centigrade"], "InlineFormula"],
     " \[LineSeparator]is a unit of temperature."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A temperature range of one ",
 Cell[BoxData["Centigrade"], "InlineFormula"],
 " is equivalent to one ",
 Cell[BoxData[
  ButtonBox["Kelvin",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Kelvin"]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->5162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvertTemperature",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ConvertTemperature"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", " ", "Centigrade", ",", " ", 
    StyleBox["newscale", "TI"]}], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " degrees ",
 Cell[BoxData["Centigrade"], "InlineFormula"],
 " into the temperature scale ",
 Cell[BoxData[
  StyleBox["newscale", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13965]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2524],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Celsius",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Celsius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fahrenheit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fahrenheit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rankine",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rankine"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16255],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->18824]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Centigrade - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 23.8511464}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Centigrade is a unit of temperature.", "synonyms" -> {}, 
    "title" -> "Centigrade", "type" -> "Symbol", "uri" -> 
    "Units/ref/Centigrade"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1343, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 60, 47, 1, 70, "ObjectName",
 CellID->6361],
Cell[2016, 63, 325, 10, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2378, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2856, 95, 286, 10, 70, "Notes",
 CellID->5162],
Cell[3145, 107, 557, 19, 70, "Notes",
 CellID->13965]
}, Closed]],
Cell[CellGroupData[{
Cell[3739, 131, 310, 9, 70, "SeeAlsoSection",
 CellID->2524],
Cell[4052, 142, 714, 26, 70, "SeeAlso",
 CellID->10418]
}, Open  ]],
Cell[CellGroupData[{
Cell[4803, 173, 314, 9, 70, "TutorialsSection",
 CellID->16255],
Cell[5120, 184, 135, 3, 70, "Tutorials",
 CellID->18824]
}, Open  ]],
Cell[5270, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

