(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7329,        261]
NotebookOptionsPosition[      5559,        203]
NotebookOutlinePosition[      6578,        232]
CellTagsIndexPosition[      6535,        229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SI" :> Documentation`HelpLookup["paclet:Units/ref/SI"], "MKS" :> 
          Documentation`HelpLookup["paclet:Units/ref/MKS"], "CGS" :> 
          Documentation`HelpLookup["paclet:Units/ref/CGS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SI\"\>", 2->"\<\"MKS\"\>", 
       3->"\<\"CGS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Convert", "ObjectName",
 CellID->25812],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Convert", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to a form involving a combination of units ",
     Cell[BoxData[
      StyleBox["newunits", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9687]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Convert"], "InlineFormula"],
 " provides a way to convert between different systems of units."
}], "Notes",
 CellID->25420],

Cell[TextData[{
 "SI unit prefixes such as ",
 Cell[BoxData[
  ButtonBox["Nano",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Nano"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Micro",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Micro"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Mega",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Mega"]], "InlineFormula"],
 " can be multiplied into unit expressions."
}], "Notes",
 CellID->18595],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ConvertTemperature",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/ConvertTemperature"]], "InlineFormula"],
 " converts temperatures between different temperature scales."
}], "Notes",
 CellID->8684]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22065],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SI",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/SI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MKS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MKS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CGS",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/CGS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4823],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16311]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Convert - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 31.7575988}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "Convert[expr, newunits] converts expr to a form involving a combination \
of units newunits.", "synonyms" -> {}, "title" -> "Convert", "type" -> 
    "Symbol", "uri" -> "Units/ref/Convert"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1284, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1907, 59, 45, 1, 70, "ObjectName",
 CellID->25812],
Cell[1955, 62, 628, 20, 70, "Usage",
 CellID->9687]
}, Open  ]],
Cell[CellGroupData[{
Cell[2620, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3098, 104, 154, 4, 70, "Notes",
 CellID->25420],
Cell[3255, 110, 486, 18, 70, "Notes",
 CellID->18595],
Cell[3744, 130, 252, 7, 70, "Notes",
 CellID->8684]
}, Closed]],
Cell[CellGroupData[{
Cell[4033, 142, 311, 9, 70, "SeeAlsoSection",
 CellID->22065],
Cell[4347, 153, 682, 26, 70, "SeeAlso",
 CellID->15219]
}, Open  ]],
Cell[CellGroupData[{
Cell[5066, 184, 313, 9, 70, "TutorialsSection",
 CellID->4823],
Cell[5382, 195, 135, 3, 70, "Tutorials",
 CellID->16311]
}, Open  ]],
Cell[5532, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

