(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9545,        327]
NotebookOptionsPosition[      7584,        264]
NotebookOutlinePosition[      8672,        294]
CellTagsIndexPosition[      8629,        291]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Kelvin" :> Documentation`HelpLookup["paclet:Units/ref/Kelvin"],
           "Celsius" :> Documentation`HelpLookup["paclet:Units/ref/Celsius"], 
          "Fahrenheit" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fahrenheit"], "Rankine" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rankine"], "Centigrade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centigrade"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Kelvin\"\>", 2->"\<\"Celsius\"\>", 
       3->"\<\"Fahrenheit\"\>", 4->"\<\"Rankine\"\>", 
       5->"\<\"Centigrade\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConvertTemperature", "ObjectName",
 CellID->21520],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConvertTemperature", "[", 
       RowBox[{
        StyleBox["temp", "TI"], ",", 
        StyleBox["oldscale", "TI"], ",", 
        StyleBox["newscale", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts temperature ",
     Cell[BoxData[
      StyleBox["temp", "TI"]], "InlineFormula"],
     " from temperature scale ",
     Cell[BoxData[
      StyleBox["oldscale", "TI"]], "InlineFormula"],
     " to scale ",
     Cell[BoxData[
      StyleBox["newscale", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22981]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings for temperature scales ",
 Cell[BoxData[
  StyleBox["oldscale", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["newscale", "TI"]], "InlineFormula"],
 " can be used:"
}], "Notes",
 CellID->11740],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Celsius",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Celsius"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Fahrenheit",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Fahrenheit"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Rankine",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Rankine"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Centigrade",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Centigrade"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Kelvin",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kelvin"]}
  }]], "1ColumnTableMod",
 CellID->29732],

Cell["\<\
The conversion of temperature units is different from most other unit \
conversions, because it is not multiplicative. This is because the zeros of \
various systems are set at different values.\
\>", "Notes",
 CellID->17177],

Cell[TextData[{
 "For example, zero degrees ",
 Cell[BoxData[
  ButtonBox["Centigrade",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Centigrade"]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData["32"], "InlineFormula"],
 " degrees ",
 Cell[BoxData[
  ButtonBox["Fahrenheit",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Fahrenheit"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Convert",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Convert"]], "InlineFormula"],
 " only converts the units of temperature. Instead use ",
 Cell[BoxData["ConvertTemperature"], "InlineFormula"],
 " to convert the actual temperatures."
}], "Notes",
 CellID->14944]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14843],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Celsius",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Celsius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fahrenheit",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fahrenheit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rankine",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rankine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centigrade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centigrade"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31662],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->23409]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConvertTemperature - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 31.9294782}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> 
    "ConvertTemperature[temp, oldscale, newscale] converts temperature temp \
from temperature scale oldscale to scale newscale.", "synonyms" -> {}, 
    "title" -> "ConvertTemperature", "type" -> "Symbol", "uri" -> 
    "Units/ref/ConvertTemperature"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1557, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2180, 63, 56, 1, 70, "ObjectName",
 CellID->21520],
Cell[2239, 66, 765, 24, 70, "Usage",
 CellID->22981]
}, Open  ]],
Cell[CellGroupData[{
Cell[3041, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3519, 112, 250, 9, 70, "Notes",
 CellID->11740],
Cell[3772, 123, 738, 22, 70, "1ColumnTableMod",
 CellID->29732],
Cell[4513, 147, 235, 5, 70, "Notes",
 CellID->17177],
Cell[4751, 154, 413, 15, 70, "Notes",
 CellID->29825],
Cell[5167, 171, 320, 9, 70, "Notes",
 CellID->14944]
}, Closed]],
Cell[CellGroupData[{
Cell[5524, 185, 311, 9, 70, "SeeAlsoSection",
 CellID->14843],
Cell[5838, 196, 1215, 44, 70, "SeeAlso",
 CellID->9592]
}, Open  ]],
Cell[CellGroupData[{
Cell[7090, 245, 314, 9, 70, "TutorialsSection",
 CellID->31662],
Cell[7407, 256, 135, 3, 70, "Tutorials",
 CellID->23409]
}, Open  ]],
Cell[7557, 262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

