(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7461,        270]
NotebookOptionsPosition[      5705,        212]
NotebookOutlinePosition[      6649,        239]
CellTagsIndexPosition[      6606,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AMU" :> Documentation`HelpLookup["paclet:Units/ref/AMU"], 
          "Gram" :> Documentation`HelpLookup["paclet:Units/ref/Gram"], 
          "AvogadroConstant" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AvogadroConstant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AMU\"\>", 2->"\<\"Gram\"\>", 
       3->"\<\"AvogadroConstant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dalton", "ObjectName",
 CellID->32689],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Dalton"], "InlineFormula"],
     " \[LineSeparator]is a unit of mass."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22007]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Dalton"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1.66054", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "27"}]], "  ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->29861],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Dalton"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Dalton"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17355],

Cell[TextData[{
 Cell[BoxData["Dalton"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["AtomicMassUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/AtomicMassUnit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26041],

Cell[TextData[{
 Cell[BoxData["Dalton"], "InlineFormula"],
 " is typically abbreviated Da."
}], "Notes",
 CellID->122256178]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29082],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AMU",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AMU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvogadroConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AvogadroConstant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24314],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->28294]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dalton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 39.1327876}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Dalton is a unit of mass.", "synonyms" -> {}, "title" -> 
    "Dalton", "type" -> "Symbol", "uri" -> "Units/ref/Dalton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1364, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1987, 61, 44, 1, 70, "ObjectName",
 CellID->32689],
Cell[2034, 64, 314, 10, 70, "Usage",
 CellID->22007]
}, Open  ]],
Cell[CellGroupData[{
Cell[2385, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2863, 96, 348, 12, 70, "Notes",
 CellID->29861],
Cell[3214, 110, 503, 19, 70, "Notes",
 CellID->17355],
Cell[3720, 131, 252, 9, 70, "Notes",
 CellID->26041],
Cell[3975, 142, 124, 4, 70, "Notes",
 CellID->122256178]
}, Closed]],
Cell[CellGroupData[{
Cell[4136, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->29082],
Cell[4450, 162, 724, 26, 70, "SeeAlso",
 CellID->15816]
}, Open  ]],
Cell[CellGroupData[{
Cell[5211, 193, 314, 9, 70, "TutorialsSection",
 CellID->24314],
Cell[5528, 204, 135, 3, 70, "Tutorials",
 CellID->28294]
}, Open  ]],
Cell[5678, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

