(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7983,        289]
NotebookOptionsPosition[      6242,        231]
NotebookOutlinePosition[      7174,        258]
CellTagsIndexPosition[      7131,        255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Week" :> Documentation`HelpLookup["paclet:Units/ref/Week"], 
          "Minute" :> Documentation`HelpLookup["paclet:Units/ref/Minute"], 
          "Year" :> Documentation`HelpLookup["paclet:Units/ref/Year"], 
          "Month" :> Documentation`HelpLookup["paclet:Units/ref/Month"], 
          "Fortnight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fortnight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Week\"\>", 2->"\<\"Minute\"\>", 
       3->"\<\"Year\"\>", 4->"\<\"Month\"\>", 
       5->"\<\"Fortnight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Day", "ObjectName",
 CellID->9765],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Day"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22052]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Day"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"86400", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->707],

Cell[TextData[{
 Cell[BoxData["Day"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"24", " ", 
   ButtonBox["Hour",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hour"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12741],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Day"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Day"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1551],

Cell[TextData[{
 Cell[BoxData["Day"], "InlineFormula"],
 " is typically abbreviated as d."
}], "Notes",
 CellID->9578]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19624],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Week",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Week"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Year",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Year"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Month",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Month"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fortnight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fortnight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->429399904]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29215],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->19811]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Day - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 39.3046670}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Day is a unit of time.", "synonyms" -> {}, "title" -> "Day",
     "type" -> "Symbol", "uri" -> "Units/ref/Day"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1521, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2144, 63, 40, 1, 70, "ObjectName",
 CellID->9765],
Cell[2187, 66, 311, 10, 70, "Usage",
 CellID->22052]
}, Open  ]],
Cell[CellGroupData[{
Cell[2535, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3013, 98, 272, 10, 70, "Notes",
 CellID->707],
Cell[3288, 110, 256, 10, 70, "Notes",
 CellID->12741],
Cell[3547, 122, 496, 19, 70, "Notes",
 CellID->1551],
Cell[4046, 143, 118, 4, 70, "Notes",
 CellID->9578]
}, Closed]],
Cell[CellGroupData[{
Cell[4201, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->19624],
Cell[4515, 163, 1196, 44, 70, "SeeAlso",
 CellID->429399904]
}, Open  ]],
Cell[CellGroupData[{
Cell[5748, 212, 314, 9, 70, "TutorialsSection",
 CellID->29215],
Cell[6065, 223, 135, 3, 70, "Tutorials",
 CellID->19811]
}, Open  ]],
Cell[6215, 229, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

