(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7199,        257]
NotebookOptionsPosition[      5474,        200]
NotebookOutlinePosition[      6446,        228]
CellTagsIndexPosition[      6403,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Celsius" :> 
          Documentation`HelpLookup["paclet:Units/ref/Celsius"], "Rankine" :> 
          Documentation`HelpLookup["paclet:Units/ref/Rankine"], "Centigrade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centigrade"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Celsius\"\>", 2->"\<\"Rankine\"\>", 
       3->"\<\"Centigrade\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fahrenheit", "ObjectName",
 CellID->9581],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Fahrenheit"], "InlineFormula"],
     " \[LineSeparator]is a unit of temperature."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A temperature range of one ",
 Cell[BoxData["Fahrenheit"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"5", "/", "9"}], " ", 
   ButtonBox["Kelvin",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kelvin"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->12693],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvertTemperature",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ConvertTemperature"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", " ", "Fahrenheit", ",", " ", 
    StyleBox["newscale", "TI"]}], "]"}]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " degrees ",
 Cell[BoxData["Fahrenheit"], "InlineFormula"],
 " into the temperature scale ",
 Cell[BoxData[
  StyleBox["newscale", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10655],

Cell[TextData[{
 Cell[BoxData["Fahrenheit"], "InlineFormula"],
 " is typically abbreviated as F."
}], "Notes",
 CellID->584597400]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->45],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Celsius",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Celsius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rankine",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Rankine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centigrade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centigrade"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30024]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26899],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5679]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fahrenheit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 54.9925686}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Fahrenheit is a unit of temperature.", "synonyms" -> {}, 
    "title" -> "Fahrenheit", "type" -> "Symbol", "uri" -> 
    "Units/ref/Fahrenheit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1343, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 60, 47, 1, 70, "ObjectName",
 CellID->9581],
Cell[2016, 63, 325, 10, 70, "Usage",
 CellID->14677]
}, Open  ]],
Cell[CellGroupData[{
Cell[2378, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2856, 95, 333, 12, 70, "Notes",
 CellID->12693],
Cell[3192, 109, 557, 19, 70, "Notes",
 CellID->10655],
Cell[3752, 130, 130, 4, 70, "Notes",
 CellID->584597400]
}, Closed]],
Cell[CellGroupData[{
Cell[3919, 139, 308, 9, 70, "SeeAlsoSection",
 CellID->45],
Cell[4230, 150, 714, 26, 70, "SeeAlso",
 CellID->30024]
}, Open  ]],
Cell[CellGroupData[{
Cell[4981, 181, 314, 9, 70, "TutorialsSection",
 CellID->26899],
Cell[5298, 192, 134, 3, 70, "Tutorials",
 CellID->5679]
}, Open  ]],
Cell[5447, 198, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

