(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6937,        246]
NotebookOptionsPosition[      5264,        191]
NotebookOutlinePosition[      6238,        219]
CellTagsIndexPosition[      6195,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abfarad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Abfarad"], "Statfarad" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statfarad"], "Amp" :> 
          Documentation`HelpLookup["paclet:Units/ref/Amp"], "Coulomb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Coulomb"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abfarad\"\>", 
       2->"\<\"Statfarad\"\>", 3->"\<\"Amp\"\>", 
       4->"\<\"Coulomb\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Farad", "ObjectName",
 CellID->25998],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Farad"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of electric capacitance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Farad"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"], "/", 
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10737],

Cell[TextData[{
 Cell[BoxData["Farad"], "InlineFormula"],
 " is typically abbreviated as F."
}], "Notes",
 CellID->10291]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11928],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abfarad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abfarad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Statfarad",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Statfarad"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coulomb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Coulomb"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16765],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->28443]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Farad - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 9, 55.1488226}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Farad is the derived SI unit of electric capacitance.", 
    "synonyms" -> {}, "title" -> "Farad", "type" -> "Symbol", "uri" -> 
    "Units/ref/Farad"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1436, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2059, 62, 43, 1, 70, "ObjectName",
 CellID->25998],
Cell[2105, 65, 342, 10, 70, "Usage",
 CellID->25625]
}, Open  ]],
Cell[CellGroupData[{
Cell[2484, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2962, 97, 343, 13, 70, "Notes",
 CellID->10737],
Cell[3308, 112, 121, 4, 70, "Notes",
 CellID->10291]
}, Closed]],
Cell[CellGroupData[{
Cell[3466, 121, 311, 9, 70, "SeeAlsoSection",
 CellID->11928],
Cell[3780, 132, 953, 35, 70, "SeeAlso",
 CellID->15357]
}, Open  ]],
Cell[CellGroupData[{
Cell[4770, 172, 314, 9, 70, "TutorialsSection",
 CellID->16765],
Cell[5087, 183, 135, 3, 70, "Tutorials",
 CellID->28443]
}, Open  ]],
Cell[5237, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

