(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8743,        311]
NotebookOptionsPosition[      6998,        253]
NotebookOutlinePosition[      7936,        280]
CellTagsIndexPosition[      7893,        277]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Feet" :> Documentation`HelpLookup["paclet:Units/ref/Feet"], 
          "Yard" :> Documentation`HelpLookup["paclet:Units/ref/Yard"], 
          "Centimeter" :> 
          Documentation`HelpLookup["paclet:Units/ref/Centimeter"], "Mile" :> 
          Documentation`HelpLookup["paclet:Units/ref/Mile"], "Hand" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hand"], "StatuteMile" :> 
          Documentation`HelpLookup["paclet:Units/ref/StatuteMile"], 
          "SurveyMile" :> 
          Documentation`HelpLookup["paclet:Units/ref/SurveyMile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Feet\"\>", 2->"\<\"Yard\"\>", 
       3->"\<\"Centimeter\"\>", 4->"\<\"Mile\"\>", 5->"\<\"Hand\"\>", 
       6->"\<\"StatuteMile\"\>", 7->"\<\"SurveyMile\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Foot", "ObjectName",
 CellID->6249],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Foot"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Foot"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"0.3048", " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->11252],

Cell[TextData[{
 Cell[BoxData["Foot"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"12", " ", 
   ButtonBox["Inch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Inch"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4229],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Foot"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Foot"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14283],

Cell[TextData[{
 Cell[BoxData["Foot"], "InlineFormula"],
 " is typically abbreviated as ft or as '."
}], "Notes",
 CellID->20351]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23316],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Feet",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Feet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Yard",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Yard"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Centimeter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Centimeter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hand",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatuteMile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/StatuteMile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SurveyMile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/SurveyMile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31356],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->4901]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Foot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 3.3365322}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Foot is a unit of length.", "synonyms" -> {}, "title" -> 
    "Foot", "type" -> "Symbol", "uri" -> "Units/ref/Foot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1755, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2378, 67, 41, 1, 70, "ObjectName",
 CellID->6249],
Cell[2422, 70, 313, 10, 70, "Usage",
 CellID->7198]
}, Open  ]],
Cell[CellGroupData[{
Cell[2772, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3250, 102, 274, 10, 70, "Notes",
 CellID->11252],
Cell[3527, 114, 256, 10, 70, "Notes",
 CellID->4229],
Cell[3786, 126, 499, 19, 70, "Notes",
 CellID->14283],
Cell[4288, 147, 129, 4, 70, "Notes",
 CellID->20351]
}, Closed]],
Cell[CellGroupData[{
Cell[4454, 156, 311, 9, 70, "SeeAlsoSection",
 CellID->23316],
Cell[4768, 167, 1700, 62, 70, "SeeAlso",
 CellID->16983]
}, Open  ]],
Cell[CellGroupData[{
Cell[6505, 234, 314, 9, 70, "TutorialsSection",
 CellID->31356],
Cell[6822, 245, 134, 3, 70, "Tutorials",
 CellID->4901]
}, Open  ]],
Cell[6971, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

