(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9031,        323]
NotebookOptionsPosition[      7223,        263]
NotebookOutlinePosition[      8169,        290]
CellTagsIndexPosition[      8126,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FluidOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/FluidOunce"], 
          "ImperialGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialGallon"], 
          "UKGallon" :> Documentation`HelpLookup["paclet:Units/ref/UKGallon"],
           "Tablespoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Tablespoon"], "Teaspoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Gill" :> 
          Documentation`HelpLookup["paclet:Units/ref/Gill"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FluidOunce\"\>", 
       2->"\<\"ImperialGallon\"\>", 3->"\<\"UKGallon\"\>", 
       4->"\<\"Tablespoon\"\>", 5->"\<\"Teaspoon\"\>", 
       6->"\<\"Gill\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gallon", "ObjectName",
 CellID->4434],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gallon"], "InlineFormula"],
     " \[LineSeparator]is a US volume unit."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gallon"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.00378541", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->18801],

Cell[TextData[{
 Cell[BoxData["Gallon"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"3.78541", " ", 
   ButtonBox["Liter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Liter"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17966],

Cell[TextData[{
 Cell[BoxData["Gallon"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"4", " ", 
   ButtonBox["Quart",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quart"]}]], "InlineFormula"],
 ", or to ",
 Cell[BoxData[
  RowBox[{"8", " ", 
   ButtonBox["Pint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pint"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14410],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Gallon"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Gallon"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1517],

Cell[TextData[{
 Cell[BoxData["Gallon"], "InlineFormula"],
 " is typically abbreviated as gal."
}], "Notes",
 CellID->23116]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10259],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FluidOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tablespoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tablespoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Teaspoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Teaspoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gill",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gill"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27084],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2084]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gallon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 3.8990466}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Gallon is a US volume unit.", "synonyms" -> {}, "title" -> 
    "Gallon", "type" -> "Symbol", "uri" -> "Units/ref/Gallon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1708, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2331, 67, 43, 1, 70, "ObjectName",
 CellID->4434],
Cell[2377, 70, 315, 10, 70, "Usage",
 CellID->4774]
}, Open  ]],
Cell[CellGroupData[{
Cell[2729, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3207, 102, 322, 11, 70, "Notes",
 CellID->18801],
Cell[3532, 115, 280, 10, 70, "Notes",
 CellID->17966],
Cell[3815, 127, 416, 16, 70, "Notes",
 CellID->14410],
Cell[4234, 145, 502, 19, 70, "Notes",
 CellID->1517],
Cell[4739, 166, 124, 4, 70, "Notes",
 CellID->23116]
}, Closed]],
Cell[CellGroupData[{
Cell[4900, 175, 311, 9, 70, "SeeAlsoSection",
 CellID->10259],
Cell[5214, 186, 1479, 53, 70, "SeeAlso",
 CellID->26009]
}, Open  ]],
Cell[CellGroupData[{
Cell[6730, 244, 314, 9, 70, "TutorialsSection",
 CellID->27084],
Cell[7047, 255, 134, 3, 70, "Tutorials",
 CellID->2084]
}, Open  ]],
Cell[7196, 261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

