(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7790,        286]
NotebookOptionsPosition[      6038,        228]
NotebookOutlinePosition[      6982,        255]
CellTagsIndexPosition[      6939,        252]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quadrant" :> 
          Documentation`HelpLookup["paclet:Units/ref/Quadrant"], "ArcMinute" :> 
          Documentation`HelpLookup["paclet:Units/ref/ArcMinute"], "ArcSecond" :> 
          Documentation`HelpLookup["paclet:Units/ref/ArcSecond"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quadrant\"\>", 
       2->"\<\"ArcMinute\"\>", 3->"\<\"ArcSecond\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Grade", "ObjectName",
 CellID->28075],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Grade"], "InlineFormula"],
     " \[LineSeparator]is a unit multiplier."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12218]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Grade"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["\[Pi]", "TR"], " ", 
     ButtonBox["Radian",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Radian"]}], ")"}], "/", "200"}]], 
  "InlineFormula"],
 ", which is approximately ",
 Cell[BoxData[
  RowBox[{"0.015708", " ", 
   ButtonBox["Radian",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Radian"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->8091],

Cell[TextData[{
 Cell[BoxData["Grade"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RightAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/RightAngle"], "/", "100"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->28735],

Cell[TextData[{
 Cell[BoxData["Grade"], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"9", "/", "10"}], " ", 
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5678],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Grade"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Grade"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12986]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8425],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quadrant",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quadrant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcMinute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ArcMinute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSecond",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ArcSecond"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->71208599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28729],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->964]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grade - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 11.4304894}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Grade is a unit multiplier.", "synonyms" -> {}, "title" -> 
    "Grade", "type" -> "Symbol", "uri" -> "Units/ref/Grade"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1349, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1972, 60, 43, 1, 70, "ObjectName",
 CellID->28075],
Cell[2018, 63, 316, 10, 70, "Usage",
 CellID->12218]
}, Open  ]],
Cell[CellGroupData[{
Cell[2371, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2849, 95, 536, 20, 70, "Notes",
 CellID->8091],
Cell[3388, 117, 269, 11, 70, "Notes",
 CellID->28735],
Cell[3660, 130, 274, 11, 70, "Notes",
 CellID->5678],
Cell[3937, 143, 501, 19, 70, "Notes",
 CellID->12986]
}, Closed]],
Cell[CellGroupData[{
Cell[4475, 167, 310, 9, 70, "SeeAlsoSection",
 CellID->8425],
Cell[4788, 178, 721, 26, 70, "SeeAlso",
 CellID->71208599]
}, Open  ]],
Cell[CellGroupData[{
Cell[5546, 209, 314, 9, 70, "TutorialsSection",
 CellID->28729],
Cell[5863, 220, 133, 3, 70, "Tutorials",
 CellID->964]
}, Open  ]],
Cell[6011, 226, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

