(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9038,        317]
NotebookOptionsPosition[      7284,        259]
NotebookOutlinePosition[      8227,        286]
CellTagsIndexPosition[      8184,        283]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TroyOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/TroyOunce"], 
          "AvoirdupoisOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisOunce"], 
          "Ounce" :> Documentation`HelpLookup["paclet:Units/ref/Ounce"], 
          "AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "Pound" :> Documentation`HelpLookup["paclet:Units/ref/Pound"], 
          "Carat" :> Documentation`HelpLookup["paclet:Units/ref/Carat"], 
          "Pennyweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pennyweight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TroyOunce\"\>", 
       2->"\<\"AvoirdupoisOunce\"\>", 3->"\<\"Ounce\"\>", 
       4->"\<\"AvoirdupoisPound\"\>", 5->"\<\"Pound\"\>", 6->"\<\"Carat\"\>", 
       7->"\<\"Pennyweight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Grain", "ObjectName",
 CellID->4101],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Grain"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Grain"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"64.799", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->25668],

Cell[TextData[{
 Cell[BoxData["Grain"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"64.799", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "3"}]], " ", 
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10353],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Grain"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Grain"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8249],

Cell[TextData[{
 Cell[BoxData["Grain"], "InlineFormula"],
 " is typically abbreviated gr."
}], "Notes",
 CellID->33158953]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32592],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TroyOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TroyOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ounce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ounce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Carat",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Carat"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pennyweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pennyweight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27941],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->9733]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Grain - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 11.6023688}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Grain is a unit of weight.", "synonyms" -> {}, "title" -> 
    "Grain", "type" -> "Symbol", "uri" -> "Units/ref/Grain"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1837, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2460, 69, 42, 1, 70, "ObjectName",
 CellID->4101],
Cell[2505, 72, 315, 10, 70, "Usage",
 CellID->29192]
}, Open  ]],
Cell[CellGroupData[{
Cell[2857, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3335, 104, 358, 12, 70, "Notes",
 CellID->25668],
Cell[3696, 118, 339, 12, 70, "Notes",
 CellID->10353],
Cell[4038, 132, 500, 19, 70, "Notes",
 CellID->8249],
Cell[4541, 153, 122, 4, 70, "Notes",
 CellID->33158953]
}, Closed]],
Cell[CellGroupData[{
Cell[4700, 162, 311, 9, 70, "SeeAlsoSection",
 CellID->32592],
Cell[5014, 173, 1740, 62, 70, "SeeAlso",
 CellID->17045]
}, Open  ]],
Cell[CellGroupData[{
Cell[6791, 240, 314, 9, 70, "TutorialsSection",
 CellID->27941],
Cell[7108, 251, 134, 3, 70, "Tutorials",
 CellID->9733]
}, Open  ]],
Cell[7257, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

