(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7004,        251]
NotebookOptionsPosition[      5272,        194]
NotebookOutlinePosition[      6256,        222]
CellTagsIndexPosition[      6213,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gal" :> Documentation`HelpLookup["paclet:Units/ref/Gal"], 
          "AccelerationDueToGravity" :> 
          Documentation`HelpLookup[
           "paclet:PhysicalConstants/ref/AccelerationDueToGravity"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Gal\"\>", 
       2->"\<\"AccelerationDueToGravity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gravity", "ObjectName",
 CellID->11659],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gravity"], "InlineFormula"],
     " \[LineSeparator]is a measure of the acceleration due to gravity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gravity"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.80665", " ", 
   RowBox[{
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "/", 
    SuperscriptBox[
     ButtonBox["Second",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Second"], "2"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->5467],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Gravity"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Gravity"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22324],

Cell[TextData[{
 Cell[BoxData["Gravity"], "InlineFormula"],
 " is typically abbreviated as g."
}], "Notes",
 CellID->21405]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9405],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AccelerationDueToGravity",
    BaseStyle->"Link",
    ButtonData->"paclet:PhysicalConstants/ref/AccelerationDueToGravity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25486]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->693],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2534]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gravity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 18.6494242}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Gravity is a measure of the acceleration due to gravity.", 
    "synonyms" -> {}, "title" -> "Gravity", "type" -> "Symbol", "uri" -> 
    "Units/ref/Gravity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1297, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1920, 60, 45, 1, 70, "ObjectName",
 CellID->11659],
Cell[1968, 63, 344, 10, 70, "Usage",
 CellID->2439]
}, Open  ]],
Cell[CellGroupData[{
Cell[2349, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2827, 95, 436, 15, 70, "Notes",
 CellID->5467],
Cell[3266, 112, 505, 19, 70, "Notes",
 CellID->22324],
Cell[3774, 133, 123, 4, 70, "Notes",
 CellID->21405]
}, Closed]],
Cell[CellGroupData[{
Cell[3934, 142, 310, 9, 70, "SeeAlsoSection",
 CellID->9405],
Cell[4247, 153, 497, 17, 70, "SeeAlso",
 CellID->25486]
}, Open  ]],
Cell[CellGroupData[{
Cell[4781, 175, 312, 9, 70, "TutorialsSection",
 CellID->693],
Cell[5096, 186, 134, 3, 70, "Tutorials",
 CellID->2534]
}, Open  ]],
Cell[5245, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

