(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8652,        303]
NotebookOptionsPosition[      6942,        247]
NotebookOutlinePosition[      7897,        274]
CellTagsIndexPosition[      7854,        271]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gallon" :> Documentation`HelpLookup["paclet:Units/ref/Gallon"],
           "Tun" :> Documentation`HelpLookup["paclet:Units/ref/Tun"], 
          "ImperialGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialGallon"], 
          "Liter" :> Documentation`HelpLookup["paclet:Units/ref/Liter"], 
          "Barrel" :> Documentation`HelpLookup["paclet:Units/ref/Barrel"], 
          "UKGallon" :> Documentation`HelpLookup["paclet:Units/ref/UKGallon"],
           "Puncheon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Puncheon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gallon\"\>", 2->"\<\"Tun\"\>", 
       3->"\<\"ImperialGallon\"\>", 4->"\<\"Liter\"\>", 5->"\<\"Barrel\"\>", 
       6->"\<\"UKGallon\"\>", 7->"\<\"Puncheon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hogshead", "ObjectName",
 CellID->26606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Hogshead"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Hogshead"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.238481", " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->16281],

Cell[TextData[{
 Cell[BoxData["Hogshead"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Butt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Butt"], "/", "2"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15376],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Hogshead"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Hogshead"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23764]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->607],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tun",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tun"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Liter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Liter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barrel",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barrel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Puncheon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Puncheon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28867]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22531],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->11830]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hogshead - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 26.8215084}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Hogshead is a unit of volume.", "synonyms" -> {}, "title" -> 
    "Hogshead", "type" -> "Symbol", "uri" -> "Units/ref/Hogshead"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1756, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2379, 66, 46, 1, 70, "ObjectName",
 CellID->26606],
Cell[2428, 69, 318, 10, 70, "Usage",
 CellID->19947]
}, Open  ]],
Cell[CellGroupData[{
Cell[2783, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3261, 101, 322, 11, 70, "Notes",
 CellID->16281],
Cell[3586, 114, 260, 10, 70, "Notes",
 CellID->15376],
Cell[3849, 126, 507, 19, 70, "Notes",
 CellID->23764]
}, Closed]],
Cell[CellGroupData[{
Cell[4393, 150, 309, 9, 70, "SeeAlsoSection",
 CellID->607],
Cell[4705, 161, 1706, 62, 70, "SeeAlso",
 CellID->28867]
}, Open  ]],
Cell[CellGroupData[{
Cell[6448, 228, 314, 9, 70, "TutorialsSection",
 CellID->22531],
Cell[6765, 239, 135, 3, 70, "Tutorials",
 CellID->11830]
}, Open  ]],
Cell[6915, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

