(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6398,        232]
NotebookOptionsPosition[      4682,        176]
NotebookOutlinePosition[      5644,        203]
CellTagsIndexPosition[      5601,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ChevalVapeur" :> 
          Documentation`HelpLookup["paclet:Units/ref/ChevalVapeur"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"ChevalVapeur\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Horsepower", "ObjectName",
 CellID->27012],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Horsepower"], "InlineFormula"],
     " \[LineSeparator]is a unit of power."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19594]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Horsepower"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"745.7", " ", 
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->4058],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Horsepower"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Horsepower"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25652],

Cell[TextData[{
 Cell[BoxData["Horsepower"], "InlineFormula"],
 " is typically abbreviated hp."
}], "Notes",
 CellID->444167930]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4760],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ChevalVapeur",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/ChevalVapeur"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->14090]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8696],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->14115]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Horsepower - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 26.9777624}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Horsepower is a unit of power.", "synonyms" -> {}, "title" -> 
    "Horsepower", "type" -> "Symbol", "uri" -> "Units/ref/Horsepower"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1149, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1772, 58, 48, 1, 70, "ObjectName",
 CellID->27012],
Cell[1823, 61, 319, 10, 70, "Usage",
 CellID->19594]
}, Open  ]],
Cell[CellGroupData[{
Cell[2179, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2657, 93, 290, 10, 70, "Notes",
 CellID->4058],
Cell[2950, 105, 511, 19, 70, "Notes",
 CellID->25652],
Cell[3464, 126, 128, 4, 70, "Notes",
 CellID->444167930]
}, Closed]],
Cell[CellGroupData[{
Cell[3629, 135, 310, 9, 70, "SeeAlsoSection",
 CellID->4760],
Cell[3942, 146, 210, 6, 70, "SeeAlso",
 CellID->14090]
}, Open  ]],
Cell[CellGroupData[{
Cell[4189, 157, 313, 9, 70, "TutorialsSection",
 CellID->8696],
Cell[4505, 168, 135, 3, 70, "Tutorials",
 CellID->14115]
}, Open  ]],
Cell[4655, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

