(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9043,        320]
NotebookOptionsPosition[      7299,        262]
NotebookOutlinePosition[      8236,        289]
CellTagsIndexPosition[      8193,        286]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Day" :> Documentation`HelpLookup["paclet:Units/ref/Day"], 
          "Week" :> Documentation`HelpLookup["paclet:Units/ref/Week"], 
          "Fortnight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fortnight"], "Month" :> 
          Documentation`HelpLookup["paclet:Units/ref/Month"], "Year" :> 
          Documentation`HelpLookup["paclet:Units/ref/Year"], "Decade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Decade"], "Century" :> 
          Documentation`HelpLookup["paclet:Units/ref/Century"], "Millennium" :> 
          Documentation`HelpLookup["paclet:Units/ref/Millennium"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Day\"\>", 2->"\<\"Week\"\>", 
       3->"\<\"Fortnight\"\>", 4->"\<\"Month\"\>", 5->"\<\"Year\"\>", 
       6->"\<\"Decade\"\>", 7->"\<\"Century\"\>", 
       8->"\<\"Millennium\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hour", "ObjectName",
 CellID->15531],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Hour"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11362]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Hour"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"3600", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->1914],

Cell[TextData[{
 Cell[BoxData["Hour"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"60", " ", 
   ButtonBox["Minute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minute"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3756],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Hour"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Hour"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10772],

Cell[TextData[{
 Cell[BoxData["Hour"], "InlineFormula"],
 " is typically abbreviated as h."
}], "Notes",
 CellID->5526]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27868],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Day",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Day"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Week",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Week"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fortnight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fortnight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Month",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Month"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Year",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Year"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Decade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Century",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Century"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Millennium",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Millennium"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29362]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26576],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->2321]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hour - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 27.1183910}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Hour is a unit of time.", "synonyms" -> {}, "title" -> 
    "Hour", "type" -> "Symbol", "uri" -> "Units/ref/Hour"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1826, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2449, 67, 42, 1, 70, "ObjectName",
 CellID->15531],
Cell[2494, 70, 312, 10, 70, "Usage",
 CellID->11362]
}, Open  ]],
Cell[CellGroupData[{
Cell[2843, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3321, 102, 273, 10, 70, "Notes",
 CellID->1914],
Cell[3597, 114, 260, 10, 70, "Notes",
 CellID->3756],
Cell[3860, 126, 499, 19, 70, "Notes",
 CellID->10772],
Cell[4362, 147, 119, 4, 70, "Notes",
 CellID->5526]
}, Closed]],
Cell[CellGroupData[{
Cell[4518, 156, 311, 9, 70, "SeeAlsoSection",
 CellID->27868],
Cell[4832, 167, 1937, 71, 70, "SeeAlso",
 CellID->29362]
}, Open  ]],
Cell[CellGroupData[{
Cell[6806, 243, 314, 9, 70, "TutorialsSection",
 CellID->26576],
Cell[7123, 254, 134, 3, 70, "Tutorials",
 CellID->2321]
}, Open  ]],
Cell[7272, 260, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

