(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9038,        314]
NotebookOptionsPosition[      7248,        255]
NotebookOutlinePosition[      8228,        283]
CellTagsIndexPosition[      8185,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GrossHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GrossHundredweight"], 
          "Stone" :> Documentation`HelpLookup["paclet:Units/ref/Stone"], 
          "LongTon" :> Documentation`HelpLookup["paclet:Units/ref/LongTon"], 
          "NetHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/NetHundredweight"], 
          "ShortHundredweight" :> 
          Documentation`HelpLookup["paclet:Units/ref/ShortHundredweight"], 
          "Quintal" :> Documentation`HelpLookup["paclet:Units/ref/Quintal"], 
          "Wey" :> Documentation`HelpLookup["paclet:Units/ref/Wey"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"GrossHundredweight\"\>", 
       2->"\<\"Stone\"\>", 3->"\<\"LongTon\"\>", 
       4->"\<\"NetHundredweight\"\>", 5->"\<\"ShortHundredweight\"\>", 
       6->"\<\"Quintal\"\>", 7->"\<\"Wey\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hundredweight", "ObjectName",
 CellID->23639],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Hundredweight"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Hundredweight"], "InlineFormula"],
 " is equivalent to approximately",
 Cell[BoxData[
  RowBox[{" ", 
   RowBox[{"50.8023", " ", 
    ButtonBox["Kilogram",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Kilogram"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->11006],

Cell[TextData[{
 Cell[BoxData["Hundredweight"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"112", " ", 
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18931],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Hundredweight"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Hundredweight"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10163],

Cell[TextData[{
 Cell[BoxData["Hundredweight"], "InlineFormula"],
 " is typically abbreviated as cwt."
}], "Notes",
 CellID->27527]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14889],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrossHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GrossHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stone",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LongTon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/LongTon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NetHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/NetHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShortHundredweight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ShortHundredweight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quintal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quintal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Wey",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Wey"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8702],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->27954]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hundredweight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 27.2902704}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Hundredweight is a unit of weight.", "synonyms" -> {}, 
    "title" -> "Hundredweight", "type" -> "Symbol", "uri" -> 
    "Units/ref/Hundredweight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1847, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2470, 68, 51, 1, 70, "ObjectName",
 CellID->23639],
Cell[2524, 71, 323, 10, 70, "Usage",
 CellID->24540]
}, Open  ]],
Cell[CellGroupData[{
Cell[2884, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3362, 103, 325, 11, 70, "Notes",
 CellID->11006],
Cell[3690, 116, 269, 10, 70, "Notes",
 CellID->18931],
Cell[3962, 128, 517, 19, 70, "Notes",
 CellID->10163],
Cell[4482, 149, 131, 4, 70, "Notes",
 CellID->27527]
}, Closed]],
Cell[CellGroupData[{
Cell[4650, 158, 311, 9, 70, "SeeAlsoSection",
 CellID->14889],
Cell[4964, 169, 1754, 62, 70, "SeeAlso",
 CellID->26985]
}, Open  ]],
Cell[CellGroupData[{
Cell[6755, 236, 313, 9, 70, "TutorialsSection",
 CellID->8702],
Cell[7071, 247, 135, 3, 70, "Tutorials",
 CellID->27954]
}, Open  ]],
Cell[7221, 253, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

