(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8363,        292]
NotebookOptionsPosition[      6627,        235]
NotebookOutlinePosition[      7610,        263]
CellTagsIndexPosition[      7567,        260]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GramWeight"], 
          "PoundForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundForce"], "Poundal" :> 
          Documentation`HelpLookup["paclet:Units/ref/Poundal"], "TonForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/TonForce"], "Dyne" :> 
          Documentation`HelpLookup["paclet:Units/ref/Dyne"], "PoundWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundWeight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GramWeight\"\>", 
       2->"\<\"PoundForce\"\>", 3->"\<\"Poundal\"\>", 4->"\<\"TonForce\"\>", 
       5->"\<\"Dyne\"\>", 6->"\<\"PoundWeight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["KilogramWeight", "ObjectName",
 CellID->13491],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["KilogramWeight"], "InlineFormula"],
     " \[LineSeparator]is a unit of force."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["KilogramWeight"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"9.80665", " ", 
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->5977],

Cell[TextData[{
 Cell[BoxData["KilogramWeight"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["KilogramForce",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/KilogramForce"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3612],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "KilogramWeight"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "KilogramWeight"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7446],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poundal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poundal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TonForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TonForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dyne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dyne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundWeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27465],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->19659]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KilogramWeight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 35.7904880}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "KilogramWeight is a unit of force.", "synonyms" -> {}, 
    "title" -> "KilogramWeight", "type" -> "Symbol", "uri" -> 
    "Units/ref/KilogramWeight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1677, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2300, 65, 52, 1, 70, "ObjectName",
 CellID->13491],
Cell[2355, 68, 323, 10, 70, "Usage",
 CellID->27830]
}, Open  ]],
Cell[CellGroupData[{
Cell[2715, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3193, 100, 300, 10, 70, "Notes",
 CellID->5977],
Cell[3496, 112, 257, 9, 70, "Notes",
 CellID->3612],
Cell[3756, 123, 519, 19, 70, "Notes",
 CellID->14781]
}, Closed]],
Cell[CellGroupData[{
Cell[4312, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->7446],
Cell[4625, 158, 1471, 53, 70, "SeeAlso",
 CellID->32535]
}, Open  ]],
Cell[CellGroupData[{
Cell[6133, 216, 314, 9, 70, "TutorialsSection",
 CellID->27465],
Cell[6450, 227, 135, 3, 70, "Tutorials",
 CellID->19659]
}, Open  ]],
Cell[6600, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

