(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8330,        293]
NotebookOptionsPosition[      6632,        237]
NotebookOutlinePosition[      7575,        264]
CellTagsIndexPosition[      7532,        261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Pound" :> Documentation`HelpLookup["paclet:Units/ref/Pound"], 
          "AvoirdupoisPound" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisPound"], 
          "Grain" :> Documentation`HelpLookup["paclet:Units/ref/Grain"], 
          "Ounce" :> Documentation`HelpLookup["paclet:Units/ref/Ounce"], 
          "AvoirdupoisOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/AvoirdupoisOunce"], 
          "Pondus" :> Documentation`HelpLookup["paclet:Units/ref/Pondus"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Pound\"\>", 
       2->"\<\"AvoirdupoisPound\"\>", 3->"\<\"Grain\"\>", 4->"\<\"Ounce\"\>", 
       5->"\<\"AvoirdupoisOunce\"\>", 
       6->"\<\"Pondus\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Libra", "ObjectName",
 CellID->13742],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Libra"], "InlineFormula"],
     " \[LineSeparator]is a unit of weight."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10789]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Libra"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"0.325971", " ", 
   ButtonBox["Kilogram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Kilogram"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->23707],

Cell[TextData[{
 Cell[BoxData["Libra"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"325.971", " ", 
   ButtonBox["Gram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gram"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18837],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Libra"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Libra"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6598]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6534],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisPound",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisPound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grain",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Grain"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ounce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ounce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AvoirdupoisOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/AvoirdupoisOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pondus",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pondus"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14152],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->31282]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Libra - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 43.1188006}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Libra is a unit of weight.", "synonyms" -> {}, "title" -> 
    "Libra", "type" -> "Symbol", "uri" -> "Units/ref/Libra"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1695, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2318, 66, 43, 1, 70, "ObjectName",
 CellID->13742],
Cell[2364, 69, 315, 10, 70, "Usage",
 CellID->10789]
}, Open  ]],
Cell[CellGroupData[{
Cell[2716, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3194, 101, 297, 10, 70, "Notes",
 CellID->23707],
Cell[3494, 113, 277, 10, 70, "Notes",
 CellID->18837],
Cell[3774, 125, 500, 19, 70, "Notes",
 CellID->6598]
}, Closed]],
Cell[CellGroupData[{
Cell[4311, 149, 310, 9, 70, "SeeAlsoSection",
 CellID->6534],
Cell[4624, 160, 1477, 53, 70, "SeeAlso",
 CellID->31962]
}, Open  ]],
Cell[CellGroupData[{
Cell[6138, 218, 314, 9, 70, "TutorialsSection",
 CellID->14152],
Cell[6455, 229, 135, 3, 70, "Tutorials",
 CellID->31282]
}, Open  ]],
Cell[6605, 235, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

