(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9935,        340]
NotebookOptionsPosition[      8240,        284]
NotebookOutlinePosition[      9183,        311]
CellTagsIndexPosition[      9140,        308]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FluidOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/FluidOunce"], "Gallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Gallon"], "Quart" :> 
          Documentation`HelpLookup["paclet:Units/ref/Quart"], "ImperialPint" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialPint"], "Pint" :> 
          Documentation`HelpLookup["paclet:Units/ref/Pint"], "ImperialGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialGallon"], 
          "Tablespoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Tablespoon"], "Teaspoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Stere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Stere"], "UKPint" :> 
          Documentation`HelpLookup["paclet:Units/ref/UKPint"], "UKGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/UKGallon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FluidOunce\"\>", 
       2->"\<\"Gallon\"\>", 3->"\<\"Quart\"\>", 4->"\<\"ImperialPint\"\>", 
       5->"\<\"Pint\"\>", 6->"\<\"ImperialGallon\"\>", 
       7->"\<\"Tablespoon\"\>", 8->"\<\"Teaspoon\"\>", 9->"\<\"Stere\"\>", 
       10->"\<\"UKPint\"\>", 11->"\<\"UKGallon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Liter", "ObjectName",
 CellID->20689],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Liter"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17494]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Liter"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"], "/", "1000"}]], 
  "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->8427],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Liter"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Liter"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->748],

Cell[TextData[{
 Cell[BoxData["Liter"], "InlineFormula"],
 " is typically abbreviated as L or l."
}], "Notes",
 CellID->24091]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23317],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FluidOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Gallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quart",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialPint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialPint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Pint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tablespoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tablespoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Teaspoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Teaspoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKPint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKPint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKGallon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20392],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->7587]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Liter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 43.6188134}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Liter is a unit of volume.", "synonyms" -> {}, "title" -> 
    "Liter", "type" -> "Symbol", "uri" -> "Units/ref/Liter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2204, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2827, 72, 43, 1, 70, "ObjectName",
 CellID->20689],
Cell[2873, 75, 315, 10, 70, "Usage",
 CellID->17494]
}, Open  ]],
Cell[CellGroupData[{
Cell[3225, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3703, 107, 303, 12, 70, "Notes",
 CellID->8427],
Cell[4009, 121, 499, 19, 70, "Notes",
 CellID->748],
Cell[4511, 142, 126, 4, 70, "Notes",
 CellID->24091]
}, Closed]],
Cell[CellGroupData[{
Cell[4674, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->23317],
Cell[4988, 162, 2722, 98, 70, "SeeAlso",
 CellID->24840]
}, Open  ]],
Cell[CellGroupData[{
Cell[7747, 265, 314, 9, 70, "TutorialsSection",
 CellID->20392],
Cell[8064, 276, 134, 3, 70, "Tutorials",
 CellID->7587]
}, Open  ]],
Cell[8213, 282, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

