(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8915,        312]
NotebookOptionsPosition[      7199,        256]
NotebookOutlinePosition[      8160,        283]
CellTagsIndexPosition[      8117,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Century" :> 
          Documentation`HelpLookup["paclet:Units/ref/Century"], "Decade" :> 
          Documentation`HelpLookup["paclet:Units/ref/Decade"], "Month" :> 
          Documentation`HelpLookup["paclet:Units/ref/Month"], "Fortnight" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fortnight"], "Week" :> 
          Documentation`HelpLookup["paclet:Units/ref/Week"], "Day" :> 
          Documentation`HelpLookup["paclet:Units/ref/Day"], "Hour" :> 
          Documentation`HelpLookup["paclet:Units/ref/Hour"], "Minute" :> 
          Documentation`HelpLookup["paclet:Units/ref/Minute"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Century\"\>", 2->"\<\"Decade\"\>", 
       3->"\<\"Month\"\>", 4->"\<\"Fortnight\"\>", 5->"\<\"Week\"\>", 
       6->"\<\"Day\"\>", 7->"\<\"Hour\"\>", 
       8->"\<\"Minute\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Millennium", "ObjectName",
 CellID->26656],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Millennium"], "InlineFormula"],
     " \[LineSeparator]is a unit of time."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10309]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Millennium"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"31536000000", " ", 
   ButtonBox["Second",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Second"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->9787],

Cell[TextData[{
 Cell[BoxData["Millennium"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1000", " ", 
   ButtonBox["Year",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Year"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5015],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Millennium"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Millennium"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28279]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22471],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Century",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Century"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decade",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Decade"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Month",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Month"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fortnight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fortnight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Week",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Week"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Day",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Day"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hour",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Hour"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minute",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minute"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10986],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->11404]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Millennium - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 10, 58.9942070}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Millennium is a unit of time.", "synonyms" -> {}, "title" -> 
    "Millennium", "type" -> "Symbol", "uri" -> "Units/ref/Millennium"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1814, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2437, 67, 48, 1, 70, "ObjectName",
 CellID->26656],
Cell[2488, 70, 318, 10, 70, "Usage",
 CellID->10309]
}, Open  ]],
Cell[CellGroupData[{
Cell[2843, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3321, 102, 286, 10, 70, "Notes",
 CellID->9787],
Cell[3610, 114, 264, 10, 70, "Notes",
 CellID->5015],
Cell[3877, 126, 511, 19, 70, "Notes",
 CellID->28279]
}, Closed]],
Cell[CellGroupData[{
Cell[4425, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->22471],
Cell[4739, 161, 1929, 71, 70, "SeeAlso",
 CellID->29968]
}, Open  ]],
Cell[CellGroupData[{
Cell[6705, 237, 314, 9, 70, "TutorialsSection",
 CellID->10986],
Cell[7022, 248, 135, 3, 70, "Tutorials",
 CellID->11404]
}, Open  ]],
Cell[7172, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

