(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7795,        280]
NotebookOptionsPosition[      6015,        221]
NotebookOutlinePosition[      6990,        249]
CellTagsIndexPosition[      6947,        246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StatuteMile" :> 
          Documentation`HelpLookup["paclet:Units/ref/StatuteMile"], "Cable" :> 
          Documentation`HelpLookup["paclet:Units/ref/Cable"], "Fathom" :> 
          Documentation`HelpLookup["paclet:Units/ref/Fathom"], "League" :> 
          Documentation`HelpLookup["paclet:Units/ref/League"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StatuteMile\"\>", 
       2->"\<\"Cable\"\>", 3->"\<\"Fathom\"\>", 
       4->"\<\"League\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NauticalMile", "ObjectName",
 CellID->23042],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["NauticalMile"], "InlineFormula"],
     " \[LineSeparator]is a unit of length."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NauticalMile"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"1852.", " ", 
   ButtonBox["Meter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Meter"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->10233],

Cell[TextData[{
 Cell[BoxData["NauticalMile"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"1.15078", " ", 
   ButtonBox["Mile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Mile"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8294],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "NauticalMile"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "NauticalMile"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27519],

Cell[TextData[{
 Cell[BoxData["NauticalMile"], "InlineFormula"],
 " is typically abbreviated as nmi or nm."
}], "Notes",
 CellID->31942]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12646],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatuteMile",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/StatuteMile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cable",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Cable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fathom",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Fathom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["League",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/League"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->561],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->21339]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NauticalMile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 7.3225452}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "NauticalMile is a unit of length.", "synonyms" -> {}, 
    "title" -> "NauticalMile", "type" -> "Symbol", "uri" -> 
    "Units/ref/NauticalMile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1442, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2065, 62, 50, 1, 70, "ObjectName",
 CellID->23042],
Cell[2118, 65, 321, 10, 70, "Usage",
 CellID->8191]
}, Open  ]],
Cell[CellGroupData[{
Cell[2476, 80, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2954, 97, 281, 10, 70, "Notes",
 CellID->10233],
Cell[3238, 109, 283, 10, 70, "Notes",
 CellID->8294],
Cell[3524, 121, 515, 19, 70, "Notes",
 CellID->27519],
Cell[4042, 142, 136, 4, 70, "Notes",
 CellID->31942]
}, Closed]],
Cell[CellGroupData[{
Cell[4215, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->12646],
Cell[4529, 162, 957, 35, 70, "SeeAlso",
 CellID->25926]
}, Open  ]],
Cell[CellGroupData[{
Cell[5523, 202, 312, 9, 70, "TutorialsSection",
 CellID->561],
Cell[5838, 213, 135, 3, 70, "Tutorials",
 CellID->21339]
}, Open  ]],
Cell[5988, 219, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

