(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7354,        263]
NotebookOptionsPosition[      5691,        208]
NotebookOutlinePosition[      6659,        236]
CellTagsIndexPosition[      6616,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lambert" :> 
          Documentation`HelpLookup["paclet:Units/ref/Lambert"], "Stilb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Stilb"], "Apostilb" :> 
          Documentation`HelpLookup["paclet:Units/ref/Apostilb"], "Lumen" :> 
          Documentation`HelpLookup["paclet:Units/ref/Lumen"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lambert\"\>", 2->"\<\"Stilb\"\>", 
       3->"\<\"Apostilb\"\>", 4->"\<\"Lumen\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nit", "ObjectName",
 CellID->13180],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Nit"], "InlineFormula"],
     " \[LineSeparator]is a unit of luminance (photometric brightness)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Nit"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Candela",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Candela"], "/", 
   RowBox[{"(", 
    SuperscriptBox[
     ButtonBox["Meter",
      BaseStyle->"Link",
      ButtonData->"paclet:Units/ref/Meter"], "2"], ")"}]}]], 
  "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->9898],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Nit"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Nit"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->607]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5898],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lambert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lambert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stilb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Stilb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apostilb",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Apostilb"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lumen",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Lumen"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27850]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25395],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->5516]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 14.5258546}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Nit is a unit of luminance (photometric brightness).", 
    "synonyms" -> {}, "title" -> "Nit", "type" -> "Symbol", "uri" -> 
    "Units/ref/Nit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1425, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2048, 61, 41, 1, 70, "ObjectName",
 CellID->13180],
Cell[2092, 64, 341, 10, 70, "Usage",
 CellID->11168]
}, Open  ]],
Cell[CellGroupData[{
Cell[2470, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2948, 96, 414, 16, 70, "Notes",
 CellID->9898],
Cell[3365, 114, 495, 19, 70, "Notes",
 CellID->607]
}, Closed]],
Cell[CellGroupData[{
Cell[3897, 138, 310, 9, 70, "SeeAlsoSection",
 CellID->5898],
Cell[4210, 149, 951, 35, 70, "SeeAlso",
 CellID->27850]
}, Open  ]],
Cell[CellGroupData[{
Cell[5198, 189, 314, 9, 70, "TutorialsSection",
 CellID->25395],
Cell[5515, 200, 134, 3, 70, "Tutorials",
 CellID->5516]
}, Open  ]],
Cell[5664, 206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

