(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6974,        251]
NotebookOptionsPosition[      5224,        194]
NotebookOutlinePosition[      6221,        222]
CellTagsIndexPosition[      6178,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BohrMagneton" :> 
          Documentation`HelpLookup["paclet:Units/ref/BohrMagneton"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"BohrMagneton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NuclearMagneton", "ObjectName",
 CellID->29417],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["NuclearMagneton"], "InlineFormula"],
     " \[LineSeparator]is a unit of magnetic moment."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24620]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NuclearMagneton"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"5.05079", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "27"}]], " ", 
   RowBox[{
    ButtonBox["Joule",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Joule"], "/", 
    ButtonBox["Tesla",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Tesla"]}]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->31508],

Cell[TextData[{
 Cell[BoxData["NuclearMagneton"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"5.0507866", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "24"}]], " ", 
   RowBox[{
    ButtonBox["Erg",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Erg"], "/", 
    ButtonBox["Gauss",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Gauss"]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20342],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "NuclearMagneton"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "NuclearMagneton"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15214]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2965],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["BohrMagneton",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/BohrMagneton"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29404],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->30335]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NuclearMagneton - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 14.8383626}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "NuclearMagneton is a unit of magnetic moment.", 
    "synonyms" -> {}, "title" -> "NuclearMagneton", "type" -> "Symbol", "uri" -> 
    "Units/ref/NuclearMagneton"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1149, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1772, 58, 53, 1, 70, "ObjectName",
 CellID->29417],
Cell[1828, 61, 334, 10, 70, "Usage",
 CellID->24620]
}, Open  ]],
Cell[CellGroupData[{
Cell[2199, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2677, 93, 478, 16, 70, "Notes",
 CellID->31508],
Cell[3158, 111, 451, 16, 70, "Notes",
 CellID->20342],
Cell[3612, 129, 521, 19, 70, "Notes",
 CellID->15214]
}, Closed]],
Cell[CellGroupData[{
Cell[4170, 153, 310, 9, 70, "SeeAlsoSection",
 CellID->2965],
Cell[4483, 164, 210, 6, 70, "SeeAlso",
 CellID->10195]
}, Open  ]],
Cell[CellGroupData[{
Cell[4730, 175, 314, 9, 70, "TutorialsSection",
 CellID->29404],
Cell[5047, 186, 135, 3, 70, "Tutorials",
 CellID->30335]
}, Open  ]],
Cell[5197, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

