(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7586,        266]
NotebookOptionsPosition[      5921,        211]
NotebookOutlinePosition[      6887,        239]
CellTagsIndexPosition[      6844,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Amp" :> Documentation`HelpLookup["paclet:Units/ref/Amp"], 
          "Henry" :> Documentation`HelpLookup["paclet:Units/ref/Henry"], 
          "Siemens" :> Documentation`HelpLookup["paclet:Units/ref/Siemens"], 
          "Watt" :> Documentation`HelpLookup["paclet:Units/ref/Watt"], 
          "Abohm" :> Documentation`HelpLookup["paclet:Units/ref/Abohm"], 
          "Statohm" :> 
          Documentation`HelpLookup["paclet:Units/ref/Statohm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Amp\"\>", 2->"\<\"Henry\"\>", 
       3->"\<\"Siemens\"\>", 4->"\<\"Watt\"\>", 5->"\<\"Abohm\"\>", 
       6->"\<\"Statohm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ohm", "ObjectName",
 CellID->30265],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Ohm"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of electric resistance."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Ohm"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Volt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Volt"], "/", 
   ButtonBox["Ampere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Ampere"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11473],

Cell[TextData[{
 Cell[BoxData["Ohm"], "InlineFormula"],
 " is typically abbreviated as \[CapitalOmega]."
}], "Notes",
 CellID->6797]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17148],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Amp",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Amp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Henry",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Henry"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Siemens",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Siemens"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Watt",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Watt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Abohm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Statohm",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Statohm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15589],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->15207]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ohm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 15.3540008}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Ohm is the derived SI unit of electric resistance.", 
    "synonyms" -> {}, "title" -> "Ohm", "type" -> "Symbol", "uri" -> 
    "Units/ref/Ohm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1609, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2232, 64, 41, 1, 70, "ObjectName",
 CellID->30265],
Cell[2276, 67, 339, 10, 70, "Usage",
 CellID->27311]
}, Open  ]],
Cell[CellGroupData[{
Cell[2652, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3130, 99, 341, 13, 70, "Notes",
 CellID->11473],
Cell[3474, 114, 132, 4, 70, "Notes",
 CellID->6797]
}, Closed]],
Cell[CellGroupData[{
Cell[3643, 123, 311, 9, 70, "SeeAlsoSection",
 CellID->17148],
Cell[3957, 134, 1433, 53, 70, "SeeAlso",
 CellID->30236]
}, Open  ]],
Cell[CellGroupData[{
Cell[5427, 192, 314, 9, 70, "TutorialsSection",
 CellID->15589],
Cell[5744, 203, 135, 3, 70, "Tutorials",
 CellID->15207]
}, Open  ]],
Cell[5894, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

