(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8479,        291]
NotebookOptionsPosition[      6813,        236]
NotebookOutlinePosition[      7780,        264]
CellTagsIndexPosition[      7737,        261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bar" :> Documentation`HelpLookup["paclet:Units/ref/Bar"], 
          "Atmosphere" :> 
          Documentation`HelpLookup["paclet:Units/ref/Atmosphere"], "PSI" :> 
          Documentation`HelpLookup["paclet:Units/ref/PSI"], "Torr" :> 
          Documentation`HelpLookup["paclet:Units/ref/Torr"], "InchMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/InchMercury"], "Barye" :> 
          Documentation`HelpLookup["paclet:Units/ref/Barye"], 
          "MillimeterMercury" :> 
          Documentation`HelpLookup["paclet:Units/ref/MillimeterMercury"], 
          "PoundsPerSquareInch" :> 
          Documentation`HelpLookup[
           "paclet:Units/ref/PoundsPerSquareInch"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bar\"\>", 2->"\<\"Atmosphere\"\>", 
       3->"\<\"PSI\"\>", 4->"\<\"Torr\"\>", 5->"\<\"InchMercury\"\>", 
       6->"\<\"Barye\"\>", 7->"\<\"MillimeterMercury\"\>", 
       8->"\<\"PoundsPerSquareInch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pascal", "ObjectName",
 CellID->11902],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Pascal"], "InlineFormula"],
     " \[LineSeparator]is the derived SI unit of pressure."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Pascal"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"], "/", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "2"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7315],

Cell[TextData[{
 Cell[BoxData["Pascal"], "InlineFormula"],
 " is typically abbreviated as Pa."
}], "Notes",
 CellID->27425]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11653],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bar",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Bar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Atmosphere",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Atmosphere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PSI",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PSI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Torr",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Torr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InchMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/InchMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Barye",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Barye"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MillimeterMercury",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/MillimeterMercury"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundsPerSquareInch",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundsPerSquareInch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10210]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19428],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->11075]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pascal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 22.5260594}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Pascal is the derived SI unit of pressure.", 
    "synonyms" -> {}, "title" -> "Pascal", "type" -> "Symbol", "uri" -> 
    "Units/ref/Pascal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1932, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2555, 70, 44, 1, 70, "ObjectName",
 CellID->11902],
Cell[2602, 73, 330, 10, 70, "Usage",
 CellID->4425]
}, Open  ]],
Cell[CellGroupData[{
Cell[2969, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3447, 105, 373, 14, 70, "Notes",
 CellID->7315],
Cell[3823, 121, 123, 4, 70, "Notes",
 CellID->27425]
}, Closed]],
Cell[CellGroupData[{
Cell[3983, 130, 311, 9, 70, "SeeAlsoSection",
 CellID->11653],
Cell[4297, 141, 1985, 71, 70, "SeeAlso",
 CellID->10210]
}, Open  ]],
Cell[CellGroupData[{
Cell[6319, 217, 314, 9, 70, "TutorialsSection",
 CellID->19428],
Cell[6636, 228, 135, 3, 70, "Tutorials",
 CellID->11075]
}, Open  ]],
Cell[6786, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

