(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10365,        358]
NotebookOptionsPosition[      8617,        300]
NotebookOutlinePosition[      9556,        327]
CellTagsIndexPosition[      9513,        324]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quart" :> Documentation`HelpLookup["paclet:Units/ref/Quart"], 
          "FluidOunce" :> 
          Documentation`HelpLookup["paclet:Units/ref/FluidOunce"], 
          "ImperialPint" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialPint"], 
          "Tablespoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Tablespoon"], "Teaspoon" :> 
          Documentation`HelpLookup["paclet:Units/ref/Teaspoon"], "Liter" :> 
          Documentation`HelpLookup["paclet:Units/ref/Liter"], "FluidDram" :> 
          Documentation`HelpLookup["paclet:Units/ref/FluidDram"], "Minim" :> 
          Documentation`HelpLookup["paclet:Units/ref/Minim"], 
          "ImperialGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/ImperialGallon"], 
          "UKPint" :> Documentation`HelpLookup["paclet:Units/ref/UKPint"], 
          "UKGallon" :> 
          Documentation`HelpLookup["paclet:Units/ref/UKGallon"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quart\"\>", 2->"\<\"FluidOunce\"\>",
        3->"\<\"ImperialPint\"\>", 4->"\<\"Tablespoon\"\>", 
       5->"\<\"Teaspoon\"\>", 6->"\<\"Liter\"\>", 7->"\<\"FluidDram\"\>", 
       8->"\<\"Minim\"\>", 9->"\<\"ImperialGallon\"\>", 10->"\<\"UKPint\"\>", 
       11->"\<\"UKGallon\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Pint", "ObjectName",
 CellID->23443],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Pint"], "InlineFormula"],
     " \[LineSeparator]is a unit of volume."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Pint"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"473.176", "\[Times]", 
   SuperscriptBox["10", 
    RowBox[{"-", "6"}]], " ", 
   SuperscriptBox[
    ButtonBox["Meter",
     BaseStyle->"Link",
     ButtonData->"paclet:Units/ref/Meter"], "3"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->25814],

Cell[TextData[{
 Cell[BoxData["Pint"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"2", " ", 
   ButtonBox["Cup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cup"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "Pint"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "Pint"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27150],

Cell[TextData[{
 Cell[BoxData["Pint"], "InlineFormula"],
 " is written in the literature as pt."
}], "Notes",
 CellID->19488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2190],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quart",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Quart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FluidOunce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidOunce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialPint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialPint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tablespoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Tablespoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Teaspoon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Teaspoon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Liter",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Liter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FluidDram",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/FluidDram"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minim",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Minim"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImperialGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/ImperialGallon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKPint",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKPint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UKGallon",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/UKGallon"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3210],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->16029]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Pint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 30.6356420}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "Pint is a unit of volume.", "synonyms" -> {}, "title" -> 
    "Pint", "type" -> "Symbol", "uri" -> "Units/ref/Pint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2249, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2872, 75, 42, 1, 70, "ObjectName",
 CellID->23443],
Cell[2917, 78, 314, 10, 70, "Usage",
 CellID->14614]
}, Open  ]],
Cell[CellGroupData[{
Cell[3268, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3746, 110, 380, 13, 70, "Notes",
 CellID->25814],
Cell[4129, 125, 248, 10, 70, "Notes",
 CellID->11503],
Cell[4380, 137, 499, 19, 70, "Notes",
 CellID->27150],
Cell[4882, 158, 125, 4, 70, "Notes",
 CellID->19488]
}, Closed]],
Cell[CellGroupData[{
Cell[5044, 167, 310, 9, 70, "SeeAlsoSection",
 CellID->2190],
Cell[5357, 178, 2730, 98, 70, "SeeAlso",
 CellID->20390]
}, Open  ]],
Cell[CellGroupData[{
Cell[8124, 281, 313, 9, 70, "TutorialsSection",
 CellID->3210],
Cell[8440, 292, 135, 3, 70, "Tutorials",
 CellID->16029]
}, Open  ]],
Cell[8590, 298, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

