(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8634,        300]
NotebookOptionsPosition[      6918,        244]
NotebookOutlinePosition[      7880,        271]
CellTagsIndexPosition[      7837,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["UNITS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Units Package" :> 
          Documentation`HelpLookup["paclet:Units/tutorial/Units"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Units Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Poundal" :> 
          Documentation`HelpLookup["paclet:Units/ref/Poundal"], 
          "KilogramForce" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramForce"], 
          "TonForce" :> Documentation`HelpLookup["paclet:Units/ref/TonForce"],
           "Dyne" :> Documentation`HelpLookup["paclet:Units/ref/Dyne"], 
          "PoundWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/PoundWeight"], 
          "KilogramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/KilogramWeight"], 
          "GramWeight" :> 
          Documentation`HelpLookup["paclet:Units/ref/GramWeight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Poundal\"\>", 
       2->"\<\"KilogramForce\"\>", 3->"\<\"TonForce\"\>", 4->"\<\"Dyne\"\>", 
       5->"\<\"PoundWeight\"\>", 6->"\<\"KilogramWeight\"\>", 
       7->"\<\"GramWeight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PoundForce", "ObjectName",
 CellID->5423],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PoundForce"], "InlineFormula"],
     " \[LineSeparator]is a unit of force."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17956]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PoundForce"], "InlineFormula"],
 " is equivalent to approximately ",
 Cell[BoxData[
  RowBox[{"4.44822", " ", 
   ButtonBox["Newton",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Newton"]}]], "InlineFormula"],
 " (SI units)."
}], "Notes",
 CellID->16828],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Convert",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Convert"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["n", "TI"], " ", "PoundForce"}], ",", 
    StyleBox["newunits", "TI"]}], "]"}]], "InlineFormula"],
 "converts ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], " ", "PoundForce"}]], "InlineFormula"],
 " to a form involving units ",
 Cell[BoxData[
  StyleBox["newunits", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13571],

Cell[TextData[{
 Cell[BoxData["PoundForce"], "InlineFormula"],
 " is typically abbreviated as lbf."
}], "Notes",
 CellID->13488]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6213],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Poundal",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Poundal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TonForce",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/TonForce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dyne",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/Dyne"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoundWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/PoundWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KilogramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/KilogramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GramWeight",
    BaseStyle->"Link",
    ButtonData->"paclet:Units/ref/GramWeight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17937],

Cell[TextData[ButtonBox["Units Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Units/tutorial/Units"]], "Tutorials",
 CellID->18915]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PoundForce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 11, 31.7450454}", "context" -> "Units`", 
    "keywords" -> {}, "index" -> True, "label" -> "Units Package Symbol", 
    "language" -> "en", "paclet" -> "Units Package", "status" -> "None", 
    "summary" -> "PoundForce is a unit of force.", "synonyms" -> {}, "title" -> 
    "PoundForce", "type" -> "Symbol", "uri" -> "Units/ref/PoundForce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1848, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2471, 70, 47, 1, 70, "ObjectName",
 CellID->5423],
Cell[2521, 73, 319, 10, 70, "Usage",
 CellID->17956]
}, Open  ]],
Cell[CellGroupData[{
Cell[2877, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3355, 105, 297, 10, 70, "Notes",
 CellID->16828],
Cell[3655, 117, 511, 19, 70, "Notes",
 CellID->13571],
Cell[4169, 138, 128, 4, 70, "Notes",
 CellID->13488]
}, Closed]],
Cell[CellGroupData[{
Cell[4334, 147, 310, 9, 70, "SeeAlsoSection",
 CellID->6213],
Cell[4647, 158, 1740, 62, 70, "SeeAlso",
 CellID->29541]
}, Open  ]],
Cell[CellGroupData[{
Cell[6424, 225, 314, 9, 70, "TutorialsSection",
 CellID->17937],
Cell[6741, 236, 135, 3, 70, "Tutorials",
 CellID->18915]
}, Open  ]],
Cell[6891, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

